
package me.snowdrop.istio.mixer.template.tracespan;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.TimeStamp;
import me.snowdrop.istio.api.cexl.TypedValue;
import me.snowdrop.istio.api.internal.MixerTemplate;
import me.snowdrop.istio.api.policy.v1beta1.IPAddress;
import me.snowdrop.istio.api.policy.v1beta1.InstanceParams;


/**
 * 
 */
@MixerTemplate(compiledTemplate = "tracespan")
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "apiProtocol",
    "clientSpan",
    "destinationIp",
    "destinationName",
    "endTime",
    "httpStatusCode",
    "name",
    "parentSpanId",
    "requestSize",
    "requestTotalSize",
    "responseSize",
    "responseTotalSize",
    "rewriteClientSpanId",
    "sourceIp",
    "sourceName",
    "spanId",
    "spanName",
    "spanTags",
    "startTime",
    "traceId"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TraceSpan implements Serializable, InstanceParams
{

    /**
     * 
     */
    @JsonProperty("apiProtocol")
    @JsonPropertyDescription("")
    private java.lang.String apiProtocol;
    /**
     * 
     */
    @JsonProperty("clientSpan")
    @JsonPropertyDescription("")
    private Boolean clientSpan;
    /**
     * 
     */
    @JsonProperty("destinationIp")
    @JsonPropertyDescription("")
    private IPAddress destinationIp;
    /**
     * 
     */
    @JsonProperty("destinationName")
    @JsonPropertyDescription("")
    private java.lang.String destinationName;
    /**
     * 
     */
    @JsonProperty("endTime")
    @JsonPropertyDescription("")
    private TimeStamp endTime;
    /**
     * 
     */
    @JsonProperty("httpStatusCode")
    @JsonPropertyDescription("")
    private Integer httpStatusCode;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     */
    @JsonProperty("parentSpanId")
    @JsonPropertyDescription("")
    private java.lang.String parentSpanId;
    /**
     * 
     */
    @JsonProperty("requestSize")
    @JsonPropertyDescription("")
    private Integer requestSize;
    /**
     * 
     */
    @JsonProperty("requestTotalSize")
    @JsonPropertyDescription("")
    private Integer requestTotalSize;
    /**
     * 
     */
    @JsonProperty("responseSize")
    @JsonPropertyDescription("")
    private Integer responseSize;
    /**
     * 
     */
    @JsonProperty("responseTotalSize")
    @JsonPropertyDescription("")
    private Integer responseTotalSize;
    /**
     * 
     */
    @JsonProperty("rewriteClientSpanId")
    @JsonPropertyDescription("")
    private Boolean rewriteClientSpanId;
    /**
     * 
     */
    @JsonProperty("sourceIp")
    @JsonPropertyDescription("")
    private IPAddress sourceIp;
    /**
     * 
     */
    @JsonProperty("sourceName")
    @JsonPropertyDescription("")
    private java.lang.String sourceName;
    /**
     * 
     */
    @JsonProperty("spanId")
    @JsonPropertyDescription("")
    private java.lang.String spanId;
    /**
     * 
     */
    @JsonProperty("spanName")
    @JsonPropertyDescription("")
    private java.lang.String spanName;
    /**
     * 
     */
    @JsonProperty("spanTags")
    @JsonPropertyDescription("")
    private Map<String, TypedValue> spanTags;
    /**
     * 
     */
    @JsonProperty("startTime")
    @JsonPropertyDescription("")
    private TimeStamp startTime;
    /**
     * 
     */
    @JsonProperty("traceId")
    @JsonPropertyDescription("")
    private java.lang.String traceId;
    private final static long serialVersionUID = 1355526131438223039L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TraceSpan() {
    }

    /**
     * 
     * @param clientSpan
     * @param traceId
     * @param requestTotalSize
     * @param responseSize
     * @param responseTotalSize
     * @param apiProtocol
     * @param parentSpanId
     * @param spanName
     * @param destinationIp
     * @param spanId
     * @param rewriteClientSpanId
     * @param sourceIp
     * @param destinationName
     * @param name
     * @param startTime
     * @param endTime
     * @param sourceName
     * @param requestSize
     * @param httpStatusCode
     * @param spanTags
     */
    public TraceSpan(java.lang.String apiProtocol, Boolean clientSpan, IPAddress destinationIp, java.lang.String destinationName, TimeStamp endTime, Integer httpStatusCode, java.lang.String name, java.lang.String parentSpanId, Integer requestSize, Integer requestTotalSize, Integer responseSize, Integer responseTotalSize, Boolean rewriteClientSpanId, IPAddress sourceIp, java.lang.String sourceName, java.lang.String spanId, java.lang.String spanName, Map<String, TypedValue> spanTags, TimeStamp startTime, java.lang.String traceId) {
        super();
        this.apiProtocol = apiProtocol;
        this.clientSpan = clientSpan;
        this.destinationIp = destinationIp;
        this.destinationName = destinationName;
        this.endTime = endTime;
        this.httpStatusCode = httpStatusCode;
        this.name = name;
        this.parentSpanId = parentSpanId;
        this.requestSize = requestSize;
        this.requestTotalSize = requestTotalSize;
        this.responseSize = responseSize;
        this.responseTotalSize = responseTotalSize;
        this.rewriteClientSpanId = rewriteClientSpanId;
        this.sourceIp = sourceIp;
        this.sourceName = sourceName;
        this.spanId = spanId;
        this.spanName = spanName;
        this.spanTags = spanTags;
        this.startTime = startTime;
        this.traceId = traceId;
    }

    /**
     * 
     */
    public java.lang.String getApiProtocol() {
        return apiProtocol;
    }

    /**
     * 
     */
    public void setApiProtocol(java.lang.String apiProtocol) {
        this.apiProtocol = apiProtocol;
    }

    /**
     * 
     */
    public Boolean getClientSpan() {
        return clientSpan;
    }

    /**
     * 
     */
    public void setClientSpan(Boolean clientSpan) {
        this.clientSpan = clientSpan;
    }

    /**
     * 
     */
    public IPAddress getDestinationIp() {
        return destinationIp;
    }

    /**
     * 
     */
    public void setDestinationIp(IPAddress destinationIp) {
        this.destinationIp = destinationIp;
    }

    /**
     * 
     */
    public java.lang.String getDestinationName() {
        return destinationName;
    }

    /**
     * 
     */
    public void setDestinationName(java.lang.String destinationName) {
        this.destinationName = destinationName;
    }

    /**
     * 
     */
    public TimeStamp getEndTime() {
        return endTime;
    }

    /**
     * 
     */
    public void setEndTime(TimeStamp endTime) {
        this.endTime = endTime;
    }

    /**
     * 
     */
    public Integer getHttpStatusCode() {
        return httpStatusCode;
    }

    /**
     * 
     */
    public void setHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    /**
     * 
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     */
    public java.lang.String getParentSpanId() {
        return parentSpanId;
    }

    /**
     * 
     */
    public void setParentSpanId(java.lang.String parentSpanId) {
        this.parentSpanId = parentSpanId;
    }

    /**
     * 
     */
    public Integer getRequestSize() {
        return requestSize;
    }

    /**
     * 
     */
    public void setRequestSize(Integer requestSize) {
        this.requestSize = requestSize;
    }

    /**
     * 
     */
    public Integer getRequestTotalSize() {
        return requestTotalSize;
    }

    /**
     * 
     */
    public void setRequestTotalSize(Integer requestTotalSize) {
        this.requestTotalSize = requestTotalSize;
    }

    /**
     * 
     */
    public Integer getResponseSize() {
        return responseSize;
    }

    /**
     * 
     */
    public void setResponseSize(Integer responseSize) {
        this.responseSize = responseSize;
    }

    /**
     * 
     */
    public Integer getResponseTotalSize() {
        return responseTotalSize;
    }

    /**
     * 
     */
    public void setResponseTotalSize(Integer responseTotalSize) {
        this.responseTotalSize = responseTotalSize;
    }

    /**
     * 
     */
    public Boolean getRewriteClientSpanId() {
        return rewriteClientSpanId;
    }

    /**
     * 
     */
    public void setRewriteClientSpanId(Boolean rewriteClientSpanId) {
        this.rewriteClientSpanId = rewriteClientSpanId;
    }

    /**
     * 
     */
    public IPAddress getSourceIp() {
        return sourceIp;
    }

    /**
     * 
     */
    public void setSourceIp(IPAddress sourceIp) {
        this.sourceIp = sourceIp;
    }

    /**
     * 
     */
    public java.lang.String getSourceName() {
        return sourceName;
    }

    /**
     * 
     */
    public void setSourceName(java.lang.String sourceName) {
        this.sourceName = sourceName;
    }

    /**
     * 
     */
    public java.lang.String getSpanId() {
        return spanId;
    }

    /**
     * 
     */
    public void setSpanId(java.lang.String spanId) {
        this.spanId = spanId;
    }

    /**
     * 
     */
    public java.lang.String getSpanName() {
        return spanName;
    }

    /**
     * 
     */
    public void setSpanName(java.lang.String spanName) {
        this.spanName = spanName;
    }

    /**
     * 
     */
    public Map<String, TypedValue> getSpanTags() {
        return spanTags;
    }

    /**
     * 
     */
    public void setSpanTags(Map<String, TypedValue> spanTags) {
        this.spanTags = spanTags;
    }

    /**
     * 
     */
    public TimeStamp getStartTime() {
        return startTime;
    }

    /**
     * 
     */
    public void setStartTime(TimeStamp startTime) {
        this.startTime = startTime;
    }

    /**
     * 
     */
    public java.lang.String getTraceId() {
        return traceId;
    }

    /**
     * 
     */
    public void setTraceId(java.lang.String traceId) {
        this.traceId = traceId;
    }

}
