package me.snowdrop.istio.mixer.template.tracespan;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.TimeStampBuilder;
import me.snowdrop.istio.api.policy.v1beta1.IPAddressFluent;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.cexl.TypedValue;
import io.fabric8.kubernetes.api.builder.Fluent;
import me.snowdrop.istio.api.TimeStamp;
import java.lang.Integer;
import me.snowdrop.istio.api.policy.v1beta1.IPAddressBuilder;
import java.lang.StringBuffer;
import me.snowdrop.istio.api.TimeStampFluent;
import java.lang.Long;
import me.snowdrop.istio.api.policy.v1beta1.IPAddress;
import java.util.Map;

public interface TraceSpanFluent<A extends TraceSpanFluent<A>> extends Fluent<A>{


    public String getApiProtocol();
    public A withApiProtocol(String apiProtocol);
    public Boolean hasApiProtocol();
    public A withNewApiProtocol(String arg1);
    public A withNewApiProtocol(StringBuilder arg1);
    public A withNewApiProtocol(StringBuffer arg1);
    public Boolean isClientSpan();
    public A withClientSpan(Boolean clientSpan);
    public Boolean hasClientSpan();
    public A withNewClientSpan(String arg1);
    public A withNewClientSpan(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildDestinationIp instead.
 * @return The buildable object.
 */
@Deprecated public IPAddress getDestinationIp();
    public IPAddress buildDestinationIp();
    public A withDestinationIp(IPAddress destinationIp);
    public Boolean hasDestinationIp();
    public A withNewDestinationIp(String value);
    public TraceSpanFluent.DestinationIpNested<A> withNewDestinationIp();
    public TraceSpanFluent.DestinationIpNested<A> withNewDestinationIpLike(IPAddress item);
    public TraceSpanFluent.DestinationIpNested<A> editDestinationIp();
    public TraceSpanFluent.DestinationIpNested<A> editOrNewDestinationIp();
    public TraceSpanFluent.DestinationIpNested<A> editOrNewDestinationIpLike(IPAddress item);
    public String getDestinationName();
    public A withDestinationName(String destinationName);
    public Boolean hasDestinationName();
    public A withNewDestinationName(String arg1);
    public A withNewDestinationName(StringBuilder arg1);
    public A withNewDestinationName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildEndTime instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getEndTime();
    public TimeStamp buildEndTime();
    public A withEndTime(TimeStamp endTime);
    public Boolean hasEndTime();
    public A withNewEndTime(Integer nanos,Long seconds);
    public TraceSpanFluent.EndTimeNested<A> withNewEndTime();
    public TraceSpanFluent.EndTimeNested<A> withNewEndTimeLike(TimeStamp item);
    public TraceSpanFluent.EndTimeNested<A> editEndTime();
    public TraceSpanFluent.EndTimeNested<A> editOrNewEndTime();
    public TraceSpanFluent.EndTimeNested<A> editOrNewEndTimeLike(TimeStamp item);
    public Integer getHttpStatusCode();
    public A withHttpStatusCode(Integer httpStatusCode);
    public Boolean hasHttpStatusCode();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getParentSpanId();
    public A withParentSpanId(String parentSpanId);
    public Boolean hasParentSpanId();
    public A withNewParentSpanId(String arg1);
    public A withNewParentSpanId(StringBuilder arg1);
    public A withNewParentSpanId(StringBuffer arg1);
    public Integer getRequestSize();
    public A withRequestSize(Integer requestSize);
    public Boolean hasRequestSize();
    public Integer getRequestTotalSize();
    public A withRequestTotalSize(Integer requestTotalSize);
    public Boolean hasRequestTotalSize();
    public Integer getResponseSize();
    public A withResponseSize(Integer responseSize);
    public Boolean hasResponseSize();
    public Integer getResponseTotalSize();
    public A withResponseTotalSize(Integer responseTotalSize);
    public Boolean hasResponseTotalSize();
    public Boolean isRewriteClientSpanId();
    public A withRewriteClientSpanId(Boolean rewriteClientSpanId);
    public Boolean hasRewriteClientSpanId();
    public A withNewRewriteClientSpanId(String arg1);
    public A withNewRewriteClientSpanId(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildSourceIp instead.
 * @return The buildable object.
 */
@Deprecated public IPAddress getSourceIp();
    public IPAddress buildSourceIp();
    public A withSourceIp(IPAddress sourceIp);
    public Boolean hasSourceIp();
    public A withNewSourceIp(String value);
    public TraceSpanFluent.SourceIpNested<A> withNewSourceIp();
    public TraceSpanFluent.SourceIpNested<A> withNewSourceIpLike(IPAddress item);
    public TraceSpanFluent.SourceIpNested<A> editSourceIp();
    public TraceSpanFluent.SourceIpNested<A> editOrNewSourceIp();
    public TraceSpanFluent.SourceIpNested<A> editOrNewSourceIpLike(IPAddress item);
    public String getSourceName();
    public A withSourceName(String sourceName);
    public Boolean hasSourceName();
    public A withNewSourceName(String arg1);
    public A withNewSourceName(StringBuilder arg1);
    public A withNewSourceName(StringBuffer arg1);
    public String getSpanId();
    public A withSpanId(String spanId);
    public Boolean hasSpanId();
    public A withNewSpanId(String arg1);
    public A withNewSpanId(StringBuilder arg1);
    public A withNewSpanId(StringBuffer arg1);
    public String getSpanName();
    public A withSpanName(String spanName);
    public Boolean hasSpanName();
    public A withNewSpanName(String arg1);
    public A withNewSpanName(StringBuilder arg1);
    public A withNewSpanName(StringBuffer arg1);
    public A addToSpanTags(String key,TypedValue value);
    public A addToSpanTags(Map<String,TypedValue> map);
    public A removeFromSpanTags(String key);
    public A removeFromSpanTags(Map<String,TypedValue> map);
    public Map<String,TypedValue> getSpanTags();
    public A withSpanTags(Map<String,TypedValue> spanTags);
    public Boolean hasSpanTags();
    
/**
 * This method has been deprecated, please use method buildStartTime instead.
 * @return The buildable object.
 */
@Deprecated public TimeStamp getStartTime();
    public TimeStamp buildStartTime();
    public A withStartTime(TimeStamp startTime);
    public Boolean hasStartTime();
    public A withNewStartTime(Integer nanos,Long seconds);
    public TraceSpanFluent.StartTimeNested<A> withNewStartTime();
    public TraceSpanFluent.StartTimeNested<A> withNewStartTimeLike(TimeStamp item);
    public TraceSpanFluent.StartTimeNested<A> editStartTime();
    public TraceSpanFluent.StartTimeNested<A> editOrNewStartTime();
    public TraceSpanFluent.StartTimeNested<A> editOrNewStartTimeLike(TimeStamp item);
    public String getTraceId();
    public A withTraceId(String traceId);
    public Boolean hasTraceId();
    public A withNewTraceId(String arg1);
    public A withNewTraceId(StringBuilder arg1);
    public A withNewTraceId(StringBuffer arg1);

    public interface DestinationIpNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IPAddressFluent<TraceSpanFluent.DestinationIpNested<N>>{

        
    public N and();    public N endDestinationIp();
}
    public interface EndTimeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeStampFluent<TraceSpanFluent.EndTimeNested<N>>{

        
    public N and();    public N endEndTime();
}
    public interface SourceIpNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IPAddressFluent<TraceSpanFluent.SourceIpNested<N>>{

        
    public N and();    public N endSourceIp();
}
    public interface StartTimeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeStampFluent<TraceSpanFluent.StartTimeNested<N>>{

        
    public N and();    public N endStartTime();
}


}
