/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import me.snowdrop.licenses.LicensesGeneratorException;
import me.snowdrop.licenses.xml.DependencyElement;
import me.snowdrop.licenses.xml.LicenseElement;
import me.snowdrop.licenses.xml.LicenseSummary;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.jtwig.JtwigModel;
import org.jtwig.JtwigTemplate;

public class LicensesFileManager {
    private final Logger logger = Logger.getLogger(LicensesFileManager.class.getSimpleName());
    private static final int DOWNLOAD_TIMEOUT = 60000;

    public void createLicensesXml(LicenseSummary licenseSummary, String directoryPath) throws LicensesGeneratorException {
        File file = new File(directoryPath, "licenses.xml");
        try {
            FileUtils.writeStringToFile((File)file, (String)licenseSummary.toXmlString());
        }
        catch (IOException | JAXBException e) {
            throw new LicensesGeneratorException("Failed to create licenses.xml", e);
        }
    }

    public void createLicensesHtml(LicenseSummary licenseSummary, String directoryPath) throws LicensesGeneratorException {
        Map<String, String> licenseFiles = this.downloadLicenseFiles(licenseSummary.getDependencies(), directoryPath);
        File file = new File(directoryPath, "licenses.html");
        JtwigTemplate template = JtwigTemplate.classpathTemplate((String)"licenses.twig");
        JtwigModel model = JtwigModel.newModel().with("dependencies", licenseSummary.getDependencies()).with("licenseFiles", licenseFiles);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            template.render(model, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            throw new LicensesGeneratorException("Failed to create licenses.html", e);
        }
    }

    private Map<String, String> downloadLicenseFiles(List<DependencyElement> dependencies, String directoryPath) {
        File licenseContentsDirectory = new File(directoryPath, "contents");
        licenseContentsDirectory.mkdirs();
        return dependencies.stream().map(DependencyElement::getLicenses).flatMap(Collection::stream).map(l -> this.downloadLicenseFile((LicenseElement)l, licenseContentsDirectory)).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Map.Entry<String, String>> downloadLicenseFile(LicenseElement license, File licenseContentsDirectory) {
        String textUrl = license.getTextUrl();
        try {
            String fileName = this.getLocalLicenseFileName(license);
            File file = new File(licenseContentsDirectory, fileName);
            boolean download = false;
            if (!file.exists()) {
                LicensesFileManager licensesFileManager = this;
                synchronized (licensesFileManager) {
                    if (!file.exists()) {
                        file.createNewFile();
                        download = true;
                    }
                }
            }
            if (download) {
                try {
                    this.downloadTo(textUrl, file);
                }
                catch (IOException any) {
                    if (!textUrl.startsWith("https")) {
                        this.downloadTo(textUrl.replace("http", "https"), file);
                    }
                    throw any;
                }
            }
            return Optional.of(new AbstractMap.SimpleEntry<String, String>(license.getName(), fileName));
        }
        catch (Exception any) {
            this.logger.warning(String.format("Failed to download license '%s' from '%s':", license.getName(), textUrl));
            any.printStackTrace();
            return Optional.empty();
        }
    }

    private void downloadTo(String url, File file) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)60000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)60000);
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (FileOutputStream stream = new FileOutputStream(file);){
                entity.writeTo((OutputStream)stream);
            }
        }
    }

    private String getLocalLicenseFileName(LicenseElement licenseElement) {
        String fileName = licenseElement.getName().replaceAll("[^A-Za-z0-9 ]", "");
        return fileName.replace(" ", "+");
    }
}

