/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.maven;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.snowdrop.licenses.maven.ProjectBuildingRequestFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;

public class MavenProjectFactory {
    private final ProjectBuilder projectBuilder;
    private final ProjectBuildingRequestFactory projectBuildingRequestFactory;

    public MavenProjectFactory(ProjectBuilder projectBuilder, ProjectBuildingRequestFactory projectBuildingRequestFactory) {
        this.projectBuilder = projectBuilder;
        this.projectBuildingRequestFactory = projectBuildingRequestFactory;
    }

    public Optional<MavenProject> getMavenProject(Artifact artifact, boolean resolveDependencies) {
        ProjectBuildingRequest request = this.projectBuildingRequestFactory.getProjectBuildingRequest();
        request.setResolveDependencies(resolveDependencies);
        try {
            ProjectBuildingResult result = this.projectBuilder.build(artifact, request);
            return Optional.ofNullable(result.getProject());
        }
        catch (ProjectBuildingException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public List<MavenProject> getMavenProjects(File pom, boolean resolveDependencies) {
        List<MavenProject> interimMavenProjects;
        ProjectBuildingRequest request = this.projectBuildingRequestFactory.getProjectBuildingRequest();
        request.setResolveDependencies(resolveDependencies);
        try {
            interimMavenProjects = this.projectBuilder.build(Collections.singletonList(pom), true, request).parallelStream().map(ProjectBuildingResult::getProject).collect(Collectors.toList());
        }
        catch (ProjectBuildingException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
        if (resolveDependencies) {
            return interimMavenProjects.parallelStream().map(p -> this.resolveMavenProject((MavenProject)p, request)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        return interimMavenProjects;
    }

    private Optional<MavenProject> resolveMavenProject(MavenProject mavenProject, ProjectBuildingRequest request) {
        try {
            ProjectBuildingResult result = this.projectBuilder.build(mavenProject.getFile(), request);
            return Optional.ofNullable(result.getProject());
        }
        catch (ProjectBuildingException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

