/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.properties;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.snowdrop.licenses.properties.GeneratorPropertiesException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class GeneratorProperties {
    private static final String DEFAULT_FILE_PATH = "generator.properties";
    private static final String DEFAULT_REPOSITORY_NAME = "Maven Central";
    private static final String DEFAULT_REPOSITORY_URL = "http://repo1.maven.org/maven2";
    private static final String DEFAULT_ALIASES_FILE_PATH = "rh-license-names.json";
    private static final String DEFAULT_EXCEPTIONS_FILE_PATH = "rh-license-exceptions.json";
    private final Configuration configuration;

    public GeneratorProperties() {
        this(DEFAULT_FILE_PATH);
    }

    public GeneratorProperties(String filePath) {
        try {
            this.configuration = new Configurations().properties(filePath);
        }
        catch (ConfigurationException e) {
            throw new GeneratorPropertiesException("Couldn't load application properties", e);
        }
    }

    public Map<String, String> getRepositories() {
        String[] urls;
        String joinedNames = this.configuration.getString("repository.names", DEFAULT_REPOSITORY_NAME);
        String joinedUrls = this.configuration.getString("repository.urls", DEFAULT_REPOSITORY_URL);
        String[] names = joinedNames.split(",");
        if (names.length != (urls = joinedUrls.split(",")).length) {
            throw new GeneratorPropertiesException("Same number of repository names and urls is expected");
        }
        return IntStream.range(0, names.length).mapToObj(i -> new AbstractMap.SimpleEntry<String, String>(names[i], urls[i])).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Optional<String> getLicenseServiceUrl() {
        String url = this.configuration.getString("licenseServiceUrl", null);
        return Optional.ofNullable(url);
    }

    public String getAliasesFilePath() {
        return this.configuration.getString("aliasesFile", DEFAULT_ALIASES_FILE_PATH);
    }

    public void setAliasesFilePath(String aliasesFilePath) {
        this.configuration.setProperty("aliasesFile", (Object)aliasesFilePath);
    }

    public String getExceptionsFilePath() {
        return this.configuration.getString("exceptionsFile", DEFAULT_EXCEPTIONS_FILE_PATH);
    }

    public void setExceptionsFilePath(String exceptionsFilePath) {
        this.configuration.setProperty("exceptionsFile", (Object)exceptionsFilePath);
    }
}

