/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;

public interface JsonUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Set<T> loadJsonToSet(String resourceLocation, Function<JsonObject, T> mapper) {
        try (InputStream fileInputStream = JsonUtils.getInputStream(resourceLocation);){
            Set set = Json.createReader((InputStream)fileInputStream).readArray().stream().map(JsonValue::asJsonObject).map(mapper).collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read the resource: " + resourceLocation, e);
        }
    }

    public static InputStream getInputStream(String resourceLocation) throws IOException {
        Path path = Paths.get(resourceLocation, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        return JsonUtils.class.getClassLoader().getResourceAsStream(resourceLocation);
    }
}

