/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.JsonString;
import me.snowdrop.licenses.xml.LicenseElement;

public class RedHatLicense {
    private String name;
    private String url;
    private String textUrl;
    private Set<String> aliases;
    private Set<String> urlAliases;

    public RedHatLicense(JsonObject jsonObject) {
        this.name = jsonObject.getString("name");
        this.url = jsonObject.getString("url");
        this.textUrl = jsonObject.getString("textUrl", this.url);
        this.aliases = this.initAliases(jsonObject);
        this.urlAliases = this.initUrlAliases(jsonObject);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Set<String> getUrlAliases() {
        return this.urlAliases;
    }

    public LicenseElement toLicenseElement() {
        return new LicenseElement(this.name, this.url, this.textUrl);
    }

    public String getTextUrl() {
        return this.textUrl;
    }

    public boolean isAliasTo(LicenseElement licenseElement) {
        return this.isNameAlias(licenseElement) || this.isUrlAlias(licenseElement);
    }

    private boolean isNameAlias(LicenseElement licenseElement) {
        String name = this.sanitiseName(licenseElement.getName());
        return name != null && this.aliases.contains(name);
    }

    private boolean isUrlAlias(LicenseElement licenseElement) {
        String url = this.sanitiseUrl(licenseElement.getUrl());
        return url != null && this.urlAliases.contains(url);
    }

    private String sanitiseName(String name) {
        if (name == null) {
            return null;
        }
        return name.trim().toLowerCase();
    }

    private String sanitiseUrl(String url) {
        if (url == null) {
            return null;
        }
        String resultUrl = url.trim().toLowerCase();
        if (resultUrl.startsWith("http://")) {
            resultUrl = resultUrl.substring(7);
        } else if (resultUrl.startsWith("https://")) {
            resultUrl = resultUrl.substring(8);
        }
        if (resultUrl.startsWith("www.")) {
            resultUrl = resultUrl.substring(4);
        }
        if (resultUrl.endsWith("/")) {
            resultUrl = resultUrl.substring(0, resultUrl.length() - 1);
        }
        return resultUrl;
    }

    private Set<String> initAliases(JsonObject jsonObject) {
        if (!jsonObject.containsKey((Object)"aliases")) {
            return new HashSet<String>();
        }
        return jsonObject.getJsonArray("aliases").getValuesAs(JsonString.class).stream().map(JsonString::getString).map(this::sanitiseName).collect(Collectors.toSet());
    }

    private Set<String> initUrlAliases(JsonObject jsonObject) {
        if (!jsonObject.containsKey((Object)"urlAliases")) {
            return new HashSet<String>();
        }
        return jsonObject.getJsonArray("urlAliases").getValuesAs(JsonString.class).stream().map(JsonString::getString).map(this::sanitiseUrl).collect(Collectors.toSet());
    }
}

