/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser.exceptions;

import java.util.Objects;
import me.snowdrop.licenses.sanitiser.exceptions.VersionMatcher;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionScheme;

class RangeVersionMatcher
implements VersionMatcher {
    private final VersionScheme scheme;
    private final VersionConstraint constraint;

    RangeVersionMatcher(String spec) {
        Objects.requireNonNull(spec, "version range spec must be set");
        this.scheme = new GenericVersionScheme();
        try {
            this.constraint = this.scheme.parseVersionConstraint(spec);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean matches(String version) {
        try {
            return this.constraint.containsVersion(this.scheme.parseVersion(version));
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }
}

