/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.core.jdbc;

import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import me.snowdrop.boot.narayana.core.jdbc.AbstractXADataSourceWrapper;
import me.snowdrop.boot.narayana.core.properties.NarayanaProperties;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.dbcp2.managed.BasicManagedDataSource;

public class PooledXADataSourceWrapper
extends AbstractXADataSourceWrapper {
    private final NarayanaProperties properties;
    private final TransactionManager transactionManager;

    public PooledXADataSourceWrapper(NarayanaProperties properties, XARecoveryModule xaRecoveryModule, TransactionManager transactionManager) {
        super(properties, xaRecoveryModule);
        this.properties = properties;
        this.transactionManager = transactionManager;
    }

    @Override
    protected DataSource wrapDataSourceInternal(XADataSource xaDataSource) throws Exception {
        BasicManagedDataSource basicManagedDataSource = new BasicManagedDataSource();
        BasicDataSource basicDataSource = this.getBasicDataSource();
        this.copyFields(basicDataSource, basicManagedDataSource);
        basicManagedDataSource.setTransactionManager(this.transactionManager);
        basicManagedDataSource.setXaDataSourceInstance(xaDataSource);
        int initialSize = Integer.valueOf(this.properties.getDbcp().getOrDefault("initialSize", "0"));
        if (initialSize > 0) {
            basicManagedDataSource.setInitialSize(initialSize);
            basicManagedDataSource.getLogWriter();
        }
        return basicManagedDataSource;
    }

    private BasicDataSource getBasicDataSource() throws Exception {
        Properties dbcpProperties = new Properties();
        dbcpProperties.putAll(this.properties.getDbcp());
        dbcpProperties.put("initialSize", "0");
        return BasicDataSourceFactory.createDataSource((Properties)dbcpProperties);
    }

    private void copyFields(Object source, Object destination) throws IllegalAccessException {
        for (Field field : source.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.get(source) == null || Modifier.isFinal(field.getModifiers())) continue;
            field.set(destination, field.get(source));
        }
    }
}

