/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.openshift.recovery;

import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.snowdrop.boot.narayana.openshift.recovery.RecoveryErrorDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogScrapingRecoveryErrorDetector
implements RecoveryErrorDetector {
    private static Logger LOG = LoggerFactory.getLogger(LogScrapingRecoveryErrorDetector.class);
    private static final String START_MESSAGE = "LOG-SCRAPING-START";
    private static final String STOP_MESSAGE = "LOG-SCRAPING-STOP";
    private String podName;
    private Predicate<String> matcher;
    private OpenShiftClient client;
    private LogWatch logWatch;
    private boolean watchClosed;
    private boolean errorMessageFound;
    private boolean startMessageFound;
    private volatile boolean stopMessageFound;
    private ExecutorService executorService;

    public LogScrapingRecoveryErrorDetector(String podName, String pattern) {
        this.podName = Objects.requireNonNull(podName, "pod name cannot be null");
        this.matcher = Pattern.compile(pattern).asPredicate();
    }

    @Override
    public void startDetection() {
        if (this.client == null && this.logWatch == null && this.executorService == null) {
            LOG.info("Log-scraping recovery error detector started: {}", (Object)START_MESSAGE);
            this.watchClosed = false;
            this.errorMessageFound = false;
            this.startMessageFound = false;
            this.stopMessageFound = false;
            this.client = new DefaultOpenShiftClient();
            this.logWatch = (LogWatch)((PodResource)this.client.pods().withName(this.podName)).watchLog();
            this.executorService = Executors.newSingleThreadExecutor();
            this.startLogScraping();
        }
    }

    protected void startLogScraping() {
        this.executorService.execute(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.logWatch.getOutput()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains(START_MESSAGE)) {
                        this.startMessageFound = true;
                        continue;
                    }
                    if (line.contains(STOP_MESSAGE)) {
                        this.stopMessageFound = true;
                        break;
                    }
                    if (!this.startMessageFound || this.stopMessageFound || !this.matcher.test(line)) continue;
                    this.errorMessageFound = true;
                    LOG.info("Found problem during log scraping");
                }
            }
            catch (Exception ex) {
                if (!this.watchClosed) {
                    throw new RuntimeException("Problem while watching the pod logs", ex);
                }
            }
            finally {
                if (!this.startMessageFound) {
                    LOG.info("Start message not found in log");
                }
                if (!this.stopMessageFound) {
                    LOG.info("Stop message not found in log");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopDetection() {
        LOG.info("Log-scraping recovery error detector stopped: {}", (Object)STOP_MESSAGE);
        this.waitForStopMessage();
        if (this.logWatch != null) {
            try {
                this.watchClosed = true;
                this.logWatch.close();
            }
            catch (Exception ex) {
                LOG.info("Problem while closing the log watch", (Throwable)ex);
            }
            finally {
                this.logWatch = null;
            }
        }
        if (this.executorService != null) {
            try {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                    if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                        LOG.info("Log scraping executor service did not terminate within the timeframe");
                    }
                }
            }
            catch (Exception ex) {
                LOG.info("Problem while closing the executor service", (Throwable)ex);
            }
            finally {
                this.executorService = null;
            }
        }
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.client = null;
            }
        }
    }

    @Override
    public boolean errorsDetected() {
        return this.errorMessageFound || !this.startMessageFound || !this.stopMessageFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStopMessage() {
        try {
            int attempts = 10;
            for (int i = 0; i < attempts && !this.stopMessageFound; ++i) {
                LOG.debug("Waiting for stop message");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    if (!this.stopMessageFound) {
                        LOG.info("Problem during log scraping: stop message not reached");
                    }
                    return;
                }
            }
        }
        finally {
            if (!this.stopMessageFound) {
                LOG.info("Problem during log scraping: stop message not reached");
            }
        }
    }
}

