/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.opentracing.tracer;

import com.uber.jaeger.Tracer;
import com.uber.jaeger.metrics.InMemoryStatsReporter;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.NullStatsReporter;
import com.uber.jaeger.metrics.StatsReporter;
import com.uber.jaeger.reporters.CompositeReporter;
import com.uber.jaeger.reporters.LoggingReporter;
import com.uber.jaeger.reporters.RemoteReporter;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.samplers.ConstSampler;
import com.uber.jaeger.samplers.HttpSamplingManager;
import com.uber.jaeger.samplers.ProbabilisticSampler;
import com.uber.jaeger.samplers.RateLimitingSampler;
import com.uber.jaeger.samplers.RemoteControlledSampler;
import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.samplers.SamplingManager;
import com.uber.jaeger.senders.HttpSender;
import com.uber.jaeger.senders.Sender;
import com.uber.jaeger.senders.UdpSender;
import com.uber.jaeger.tracerresolver.JaegerTracerResolver;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.StreamSupport;
import me.snowdrop.opentracing.tracer.JaegerConfigurationProperties;
import me.snowdrop.opentracing.tracer.JaegerTracerCustomizer;
import me.snowdrop.opentracing.tracer.ReporterAppender;
import me.snowdrop.opentracing.tracer.customizers.B3CodecJaegerTracerCustomizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={com.uber.jaeger.Tracer.class})
@ConditionalOnMissingBean(value={Tracer.class})
@ConditionalOnProperty(value={"opentracing.jaeger.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(name={"io.opentracing.contrib.spring.web.autoconfig.TracerAutoConfiguration"})
public class JaegerAutoConfiguration {

    @Configuration
    @ConditionalOnProperty(value={"opentracing.jaeger.useTracerResolver"}, havingValue="true")
    @ConditionalOnClass(value={JaegerTracerResolver.class})
    public static class TracerResolverConfiguration {
        @Bean
        public Tracer tracer(AbstractEnvironment environment) {
            this.copyJaegerPropertiesFromSpringEnvToSystemProps(environment);
            return TracerResolver.resolveTracer();
        }

        private void copyJaegerPropertiesFromSpringEnvToSystemProps(AbstractEnvironment environment) {
            StreamSupport.stream(environment.getPropertySources().spliterator(), false).filter(ps -> ps instanceof EnumerablePropertySource).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream).map(prop -> new Tuple2<String, String>((String)prop, prop.toUpperCase().replace('.', '_'))).filter(t -> ((String)t.getV2()).startsWith("JAEGER")).filter(t -> !System.getProperties().containsKey(t.getV2())).forEach(t -> System.setProperty((String)t.getV2(), environment.getProperty((String)t.getV1())));
        }

        private static class Tuple2<T1, T2> {
            private final T1 v1;
            private final T2 v2;

            Tuple2(T1 v1, T2 v2) {
                this.v1 = v1;
                this.v2 = v2;
            }

            public T1 getV1() {
                return this.v1;
            }

            public T2 getV2() {
                return this.v2;
            }
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"opentracing.jaeger.useTracerResolver"}, havingValue="false", matchIfMissing=true)
    @EnableConfigurationProperties(value={JaegerConfigurationProperties.class})
    public static class ExplicitConfiguration {
        @Autowired(required=false)
        private List<JaegerTracerCustomizer> tracerCustomizers = Collections.emptyList();

        @Bean
        public Tracer tracer(JaegerConfigurationProperties jaegerConfigurationProperties, Sampler sampler, Reporter reporter) {
            Tracer.Builder builder = new Tracer.Builder(jaegerConfigurationProperties.getServiceName(), reporter, sampler);
            this.tracerCustomizers.forEach(c -> c.customize(builder));
            return builder.build();
        }

        @ConditionalOnMissingBean
        @Bean
        public Reporter reporter(JaegerConfigurationProperties properties, Metrics metrics, @Autowired(required=false) ReporterAppender reporterAppender) {
            JaegerConfigurationProperties.UdpSender udpSender;
            LinkedList<Reporter> reporters = new LinkedList<Reporter>();
            JaegerConfigurationProperties.RemoteReporterProperties remoteReporterProperties = properties.getRemoteReporterProperties();
            JaegerConfigurationProperties.HttpSender httpSender = properties.getHttpSender();
            if (!StringUtils.isEmpty((Object)httpSender.getUrl()) && !httpSender.isDisable()) {
                reporters.add(this.getHttpReporter(metrics, remoteReporterProperties, httpSender));
            }
            if (!StringUtils.isEmpty((Object)(udpSender = properties.getUdpSender()).getHost()) && !udpSender.isDisable()) {
                reporters.add(this.getUdpReporter(metrics, remoteReporterProperties, udpSender));
            }
            if (properties.isLogSpans()) {
                reporters.add((Reporter)new LoggingReporter());
            }
            if (reporterAppender != null) {
                reporterAppender.append(reporters);
            }
            return new CompositeReporter(reporters.toArray(new Reporter[reporters.size()]));
        }

        private Reporter getUdpReporter(Metrics metrics, JaegerConfigurationProperties.RemoteReporterProperties remoteReporterProperties, JaegerConfigurationProperties.UdpSender udpSenderProperties) {
            UdpSender udpSender = new UdpSender(udpSenderProperties.getHost(), udpSenderProperties.getPort(), udpSenderProperties.getMaxPacketSize());
            return new RemoteReporter((Sender)udpSender, remoteReporterProperties.getFlushInterval(), remoteReporterProperties.getMaxQueueSize(), metrics);
        }

        private Reporter getHttpReporter(Metrics metrics, JaegerConfigurationProperties.RemoteReporterProperties remoteReporterProperties, JaegerConfigurationProperties.HttpSender httpSenderProperties) {
            HttpSender httpSender = new HttpSender(httpSenderProperties.getUrl(), httpSenderProperties.getMaxPayload());
            return new RemoteReporter((Sender)httpSender, remoteReporterProperties.getFlushInterval(), remoteReporterProperties.getMaxQueueSize(), metrics);
        }

        @ConditionalOnMissingBean
        @Bean
        public Metrics reporterMetrics(StatsReporter statsReporter) {
            return Metrics.fromStatsReporter((StatsReporter)statsReporter);
        }

        @ConditionalOnMissingBean
        @Bean
        public StatsReporter statsReporter(JaegerConfigurationProperties properties) {
            if (properties.isEnableMetrics()) {
                return new InMemoryStatsReporter();
            }
            return new NullStatsReporter();
        }

        @ConditionalOnProperty(value={"opentracing.jaeger.enableB3Propagation"}, havingValue="true")
        @Bean
        public JaegerTracerCustomizer b3CodecJaegerTracerCustomizer() {
            return new B3CodecJaegerTracerCustomizer();
        }

        @ConditionalOnMissingBean
        @Bean
        public Sampler sampler(JaegerConfigurationProperties properties, Metrics metrics) {
            if (properties.getConstSampler().getDecision() != null) {
                return new ConstSampler(properties.getConstSampler().getDecision().booleanValue());
            }
            if (properties.getProbabilisticSampler().getSamplingRate() != null) {
                return new ProbabilisticSampler(properties.getProbabilisticSampler().getSamplingRate().doubleValue());
            }
            if (properties.getRateLimitingSampler().getMaxTracesPerSecond() != null) {
                return new RateLimitingSampler(properties.getRateLimitingSampler().getMaxTracesPerSecond().doubleValue());
            }
            if (!StringUtils.isEmpty((Object)properties.getRemoteControlledSampler().getHostPort())) {
                JaegerConfigurationProperties.RemoteControlledSampler samplerProperties = properties.getRemoteControlledSampler();
                ProbabilisticSampler initialSampler = new ProbabilisticSampler(samplerProperties.getSamplingRate().doubleValue());
                HttpSamplingManager manager = new HttpSamplingManager(samplerProperties.getHostPort());
                return new RemoteControlledSampler(properties.getServiceName(), (SamplingManager)manager, (Sampler)initialSampler, metrics);
            }
            return new ConstSampler(true);
        }
    }
}

