/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.opentracing.tracer;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="opentracing.jaeger")
public class JaegerConfigurationProperties {
    private boolean enabled = true;
    private boolean useTracerResolver = false;
    private String serviceName = "spring-boot";
    private boolean logSpans = false;
    private boolean enableB3Propagation = false;
    private boolean enableMetrics = false;
    private final RemoteReporterProperties remoteReporterProperties = new RemoteReporterProperties();
    private final HttpSender httpSender = new HttpSender();
    private final UdpSender udpSender = new UdpSender();
    private final ConstSampler constSampler = new ConstSampler();
    private final ProbabilisticSampler probabilisticSampler = new ProbabilisticSampler();
    private final RateLimitingSampler rateLimitingSampler = new RateLimitingSampler();
    private final RemoteControlledSampler remoteControlledSampler = new RemoteControlledSampler();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isUseTracerResolver() {
        return this.useTracerResolver;
    }

    public void setUseTracerResolver(boolean useTracerResolver) {
        this.useTracerResolver = useTracerResolver;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isLogSpans() {
        return this.logSpans;
    }

    public void setLogSpans(boolean logSpans) {
        this.logSpans = logSpans;
    }

    public boolean isEnableB3Propagation() {
        return this.enableB3Propagation;
    }

    public void setEnableB3Propagation(boolean enableB3Propagation) {
        this.enableB3Propagation = enableB3Propagation;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public void setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public RemoteReporterProperties getRemoteReporterProperties() {
        return this.remoteReporterProperties;
    }

    public UdpSender getUdpSender() {
        return this.udpSender;
    }

    public ConstSampler getConstSampler() {
        return this.constSampler;
    }

    public ProbabilisticSampler getProbabilisticSampler() {
        return this.probabilisticSampler;
    }

    public RateLimitingSampler getRateLimitingSampler() {
        return this.rateLimitingSampler;
    }

    public RemoteControlledSampler getRemoteControlledSampler() {
        return this.remoteControlledSampler;
    }

    public static class RemoteControlledSampler {
        private String hostPort;
        private Double samplingRate = 0.001;

        public String getHostPort() {
            return this.hostPort;
        }

        public void setHostPort(String hostPort) {
            this.hostPort = hostPort;
        }

        public Double getSamplingRate() {
            return this.samplingRate;
        }

        public void setSamplingRate(Double samplingRate) {
            this.samplingRate = samplingRate;
        }
    }

    public static class RateLimitingSampler {
        private Double maxTracesPerSecond;

        public Double getMaxTracesPerSecond() {
            return this.maxTracesPerSecond;
        }

        public void setMaxTracesPerSecond(Double maxTracesPerSecond) {
            this.maxTracesPerSecond = maxTracesPerSecond;
        }
    }

    public static class ProbabilisticSampler {
        private Double samplingRate;

        public Double getSamplingRate() {
            return this.samplingRate;
        }

        public void setSamplingRate(Double samplingRate) {
            this.samplingRate = samplingRate;
        }
    }

    public static class ConstSampler {
        private Boolean decision;

        public Boolean getDecision() {
            return this.decision;
        }

        public void setDecision(Boolean decision) {
            this.decision = decision;
        }
    }

    public static class UdpSender {
        private String host;
        private int port;
        private int maxPacketSize = 65000;
        private boolean disable = false;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getMaxPacketSize() {
            return this.maxPacketSize;
        }

        public void setMaxPacketSize(int maxPacketSize) {
            this.maxPacketSize = maxPacketSize;
        }

        public boolean isDisable() {
            return this.disable;
        }

        public void setDisable(boolean disable) {
            this.disable = disable;
        }
    }

    public static class HttpSender {
        private String url;
        private int maxPayload = 0x100000;
        private boolean disable = false;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getMaxPayload() {
            return this.maxPayload;
        }

        public void setMaxPayload(int maxPayload) {
            this.maxPayload = maxPayload;
        }

        public boolean isDisable() {
            return this.disable;
        }

        public void setDisable(boolean disable) {
            this.disable = disable;
        }
    }

    public static class RemoteReporterProperties {
        private int flushInterval = 1000;
        private int maxQueueSize = 100;

        public int getFlushInterval() {
            return this.flushInterval;
        }

        public void setFlushInterval(int flushInterval) {
            this.flushInterval = flushInterval;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }
    }
}

