/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana;

import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.UserTransaction;
import java.io.File;
import javax.jms.Message;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import me.snowdrop.boot.narayana.DelegatingXAConnectionFactoryWrapper;
import me.snowdrop.boot.narayana.DelegatingXADataSourceWrapper;
import me.snowdrop.boot.narayana.core.autoconfigure.AbstractNarayanaConfiguration;
import me.snowdrop.boot.narayana.core.autoconfigure.NarayanaBeanFactoryPostProcessor;
import me.snowdrop.boot.narayana.core.jdbc.NarayanaXADataSourceWrapper;
import me.snowdrop.boot.narayana.core.jms.NarayanaXAConnectionFactoryWrapper;
import me.snowdrop.boot.narayana.core.properties.NarayanaProperties;
import org.jboss.narayana.jta.jms.TransactionHelper;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.ApplicationHome;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.autoconfigure.transaction.jta.JtaAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.jta.JtaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jta.XAConnectionFactoryWrapper;
import org.springframework.boot.jta.XADataSourceWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={JtaProperties.class, NarayanaProperties.class})
@ConditionalOnProperty(prefix="spring.jta", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Transaction.class, JtaTransactionManager.class, XAResourceRecoveryRegistry.class, UserTransaction.class})
@ConditionalOnMissingBean(value={PlatformTransactionManager.class})
@AutoConfigureBefore(value={JtaAutoConfiguration.class})
public class SpringBoot1NarayanaConfiguration
extends AbstractNarayanaConfiguration {
    private final JtaProperties jtaProperties;

    public SpringBoot1NarayanaConfiguration(JtaProperties jtaProperties, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        super(jtaProperties, transactionManagerCustomizers);
        this.jtaProperties = jtaProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public static NarayanaBeanFactoryPostProcessor narayanaBeanFactoryPostProcessor() {
        return new NarayanaBeanFactoryPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(value={XADataSourceWrapper.class})
    public XADataSourceWrapper xaDataSourceWrapper(NarayanaProperties narayanaProperties, XARecoveryModule xaRecoveryModule) {
        NarayanaXADataSourceWrapper narayanaXADataSourceWrapper = new NarayanaXADataSourceWrapper(narayanaProperties, xaRecoveryModule);
        return new DelegatingXADataSourceWrapper(narayanaXADataSourceWrapper);
    }

    protected File getLogDir() {
        if (StringUtils.hasLength((String)this.jtaProperties.getLogDir())) {
            return new File(this.jtaProperties.getLogDir());
        }
        File home = new ApplicationHome().getDir();
        return new File(home, "transaction-logs");
    }

    @Configuration
    @ConditionalOnClass(value={Message.class, TransactionHelper.class})
    static class NarayanaJmsConfiguration {
        NarayanaJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XAConnectionFactoryWrapper.class})
        public XAConnectionFactoryWrapper xaConnectionFactoryWrapper(TransactionManager transactionManager, XARecoveryModule xaRecoveryModule, NarayanaProperties narayanaProperties) {
            NarayanaXAConnectionFactoryWrapper narayanaXAConnectionFactoryWrapper = new NarayanaXAConnectionFactoryWrapper(transactionManager, xaRecoveryModule, narayanaProperties);
            return new DelegatingXAConnectionFactoryWrapper(narayanaXAConnectionFactoryWrapper);
        }
    }
}

