/*
 * Decompiled with CFR 0.152.
 */
package auto.parcelgson.processor;

import auto.parcelgson.processor.JavaTokenizer;
import com.google.common.collect.ImmutableListMultimap;
import java.util.ArrayDeque;

final class AbstractMethodExtractor {
    AbstractMethodExtractor() {
    }

    ImmutableListMultimap<String, String> abstractMethods(JavaTokenizer tokenizer, String packageName) {
        ImmutableListMultimap.Builder abstractMethods = ImmutableListMultimap.builder();
        ArrayDeque<String> classStack = new ArrayDeque<String>();
        classStack.addLast(packageName);
        int braceDepth = 1;
        boolean sawAbstract = false;
        String className = null;
        String previousToken = "";
        String token = tokenizer.nextToken();
        while (token != null) {
            boolean topLevel;
            boolean bl = topLevel = braceDepth == classStack.size();
            if (className != null) {
                if (Character.isJavaIdentifierStart(className.charAt(0)) && !className.equals("instanceof")) {
                    String container = (String)classStack.getLast();
                    classStack.add(container.isEmpty() ? className : container + "." + className);
                }
                className = null;
            }
            if (token.equals("{")) {
                ++braceDepth;
                sawAbstract = false;
            } else if (token.equals("}")) {
                --braceDepth;
                if (topLevel) {
                    classStack.removeLast();
                }
            } else if (topLevel) {
                if (token.equals("class") || token.equals("interface")) {
                    className = tokenizer.nextToken();
                } else if (token.equals("abstract")) {
                    sawAbstract = true;
                } else if (token.equals("(")) {
                    if (sawAbstract && Character.isJavaIdentifierStart(previousToken.charAt(0))) {
                        abstractMethods.put(classStack.getLast(), (Object)previousToken);
                    }
                    sawAbstract = false;
                }
            }
            previousToken = token;
            token = tokenizer.nextToken();
        }
        return abstractMethods.build();
    }
}

