/*
 * Decompiled with CFR 0.152.
 */
package auto.parcelgson.processor;

import auto.parcelgson.AutoParcelGson;
import com.google.auto.common.MoreElements;
import com.google.auto.common.SuperficialValidation;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public class AutoParcelBuilderProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AutoParcelGson.Builder.class.getCanonicalName(), (Object)AutoParcelGson.Validate.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> builderTypes = roundEnv.getElementsAnnotatedWith(AutoParcelGson.Builder.class);
        if (!SuperficialValidation.validateElements(builderTypes)) {
            return false;
        }
        for (Element element : builderTypes) {
            if (!MoreElements.isAnnotationPresent((Element)element, AutoParcelGson.Builder.class)) continue;
            this.validate(element, "@AutoParcelGson.Builder can only be applied to a class or interface inside an @AutoParcelGson class");
        }
        Set<? extends Element> validateMethods = roundEnv.getElementsAnnotatedWith(AutoParcelGson.Validate.class);
        if (!SuperficialValidation.validateElements(validateMethods)) {
            return false;
        }
        for (Element element : validateMethods) {
            if (!MoreElements.isAnnotationPresent((Element)element, AutoParcelGson.Validate.class)) continue;
            this.validate(element, "@AutoParcelGson.Validate can only be applied to a method inside an @AutoParcelGson class");
        }
        return false;
    }

    private void validate(Element annotatedType, String errorMessage) {
        Element container = annotatedType.getEnclosingElement();
        if (!MoreElements.isAnnotationPresent((Element)container, AutoParcelGson.class)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, errorMessage, annotatedType);
        }
    }
}

