/*
 * Decompiled with CFR 0.152.
 */
package auto.parcelgson.processor;

import auto.parcelgson.AutoParcelGson;
import auto.parcelgson.processor.AbortProcessingException;
import auto.parcelgson.processor.AnnotationOutput;
import auto.parcelgson.processor.AutoParcelTemplateVars;
import auto.parcelgson.processor.BuilderSpec;
import auto.parcelgson.processor.EclipseHack;
import auto.parcelgson.processor.ErrorReporter;
import auto.parcelgson.processor.GwtCompatibility;
import auto.parcelgson.processor.GwtSerialization;
import auto.parcelgson.processor.MissingTypeException;
import auto.parcelgson.processor.Reformatter;
import auto.parcelgson.processor.SimpleNameFunction;
import auto.parcelgson.processor.TypeMirrorSet;
import auto.parcelgson.processor.TypeSimplifier;
import com.google.auto.service.AutoService;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@AutoService(value=Processor.class)
public class AutoParcelProcessor
extends AbstractProcessor {
    private static final ImmutableMap<String, String> FIELD_ANNOTATION_MAP = ImmutableMap.builder().put((Object)"@auto.parcelgson.gson.annotations.Expose", (Object)"@com.google.gson.annotations.Expose").put((Object)"@auto.parcelgson.gson.annotations.JsonAdapter", (Object)"@com.google.gson.annotations.JsonAdapter").put((Object)"@auto.parcelgson.gson.annotations.SerializedName", (Object)"@com.google.gson.annotations.SerializedName").put((Object)"@auto.parcelgson.gson.annotations.Since", (Object)"@com.google.gson.annotations.Since").put((Object)"@auto.parcelgson.gson.annotations.Until", (Object)"@com.google.gson.annotations.Until").build();
    private ErrorReporter errorReporter;
    private final List<String> deferredTypeNames = new ArrayList<String>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AutoParcelGson.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.errorReporter = new ErrorReporter(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<TypeElement> deferredTypes = new ArrayList<TypeElement>();
        for (String deferred : this.deferredTypeNames) {
            deferredTypes.add(this.processingEnv.getElementUtils().getTypeElement(deferred));
        }
        if (roundEnv.processingOver()) {
            for (TypeElement type : deferredTypes) {
                this.errorReporter.reportError("Did not generate AutoParcelGson class for " + type.getQualifiedName() + " because it references undefined types", type);
            }
            return false;
        }
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(AutoParcelGson.class);
        ImmutableList types = new ImmutableList.Builder().addAll(deferredTypes).addAll(ElementFilter.typesIn(annotatedElements)).build();
        this.deferredTypeNames.clear();
        for (TypeElement type : types) {
            try {
                this.processType(type);
            }
            catch (AbortProcessingException abortProcessingException) {
            }
            catch (MissingTypeException e) {
                this.deferredTypeNames.add(type.getQualifiedName().toString());
            }
            catch (RuntimeException e) {
                String trace = Throwables.getStackTraceAsString((Throwable)e);
                this.errorReporter.reportError("AutoParcelGson processor threw an exception: " + trace, type);
            }
        }
        return false;
    }

    private String generatedClassName(TypeElement type, String prefix) {
        String name = type.getSimpleName().toString();
        while (type.getEnclosingElement() instanceof TypeElement) {
            type = (TypeElement)type.getEnclosingElement();
            name = type.getSimpleName() + "_" + name;
        }
        String pkg = TypeSimplifier.packageNameOf(type);
        String dot = pkg.isEmpty() ? "" : ".";
        return pkg + dot + prefix + name;
    }

    private String generatedSubclassName(TypeElement type) {
        return this.generatedClassName(type, "AutoParcelGson_");
    }

    private static boolean isJavaLangObject(TypeElement type) {
        return type.getSuperclass().getKind() == TypeKind.NONE && type.getKind() == ElementKind.CLASS;
    }

    private static ObjectMethodToOverride objectMethodToOverride(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        switch (method.getParameters().size()) {
            case 0: {
                if (name.equals("toString")) {
                    return ObjectMethodToOverride.TO_STRING;
                }
                if (name.equals("hashCode")) {
                    return ObjectMethodToOverride.HASH_CODE;
                }
                if (!name.equals("describeContents")) break;
                return ObjectMethodToOverride.DESCRIBE_CONTENTS;
            }
            case 1: {
                if (!name.equals("equals") || !method.getParameters().get(0).asType().toString().equals("java.lang.Object")) break;
                return ObjectMethodToOverride.EQUALS;
            }
            case 2: {
                if (!name.equals("writeToParcel") || !method.getParameters().get(0).asType().toString().equals("android.os.Parcel") || !method.getParameters().get(1).asType().toString().equals("int")) break;
                return ObjectMethodToOverride.WRITE_TO_PARCEL;
            }
        }
        return ObjectMethodToOverride.NONE;
    }

    private void findLocalAndInheritedMethods(TypeElement type, List<ExecutableElement> methods) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        Elements elementUtils = this.processingEnv.getElementUtils();
        for (TypeMirror typeMirror : type.getInterfaces()) {
            this.findLocalAndInheritedMethods((TypeElement)typeUtils.asElement(typeMirror), methods);
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            this.findLocalAndInheritedMethods((TypeElement)typeUtils.asElement(type.getSuperclass()), methods);
        }
        List<ExecutableElement> theseMethods = ElementFilter.methodsIn(type.getEnclosedElements());
        for (ExecutableElement method : theseMethods) {
            if (method.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            boolean alreadySeen = false;
            Iterator<ExecutableElement> methodIter = methods.iterator();
            while (methodIter.hasNext()) {
                ExecutableElement otherMethod = methodIter.next();
                if (elementUtils.overrides(method, otherMethod, type)) {
                    methodIter.remove();
                    continue;
                }
                if (!method.getSimpleName().equals(otherMethod.getSimpleName()) || !method.getParameters().equals(otherMethod.getParameters())) continue;
                alreadySeen = true;
            }
            if (alreadySeen) continue;
            methods.add(method);
        }
    }

    private void findClassAnnotations(TypeElement type, TypeSimplifier typeSimplifier, List<String> annotations) {
        block0: for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (annotationElement.getQualifiedName().toString().equals(Override.class.getName())) continue;
            AnnotationOutput annotationOutput = new AnnotationOutput(typeSimplifier);
            String annotationSource = annotationOutput.sourceFormForAnnotation(annotationMirror);
            for (Map.Entry entry : FIELD_ANNOTATION_MAP.entrySet()) {
                if (annotationSource.startsWith((String)entry.getValue())) {
                    annotations.add(annotationSource);
                    continue;
                }
                if (!annotationSource.startsWith((String)entry.getKey())) continue;
                annotations.add(annotationSource.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue()));
                continue block0;
            }
        }
    }

    private void processType(TypeElement type) {
        AutoParcelGson autoValue = type.getAnnotation(AutoParcelGson.class);
        if (autoValue == null) {
            this.errorReporter.abortWithError("annotation processor for AutoParcelGson was invoked with a type that does not have that annotation; this is probably a compiler bug", type);
        }
        if (type.getKind() != ElementKind.CLASS) {
            this.errorReporter.abortWithError(AutoParcelGson.class.getName() + " only applies to classes", type);
        }
        if (this.ancestorIsAutoParcel(type)) {
            this.errorReporter.abortWithError("One AutoParcelGson class may not extend another", type);
        }
        if (this.implementsAnnotation(type)) {
            this.errorReporter.abortWithError("AutoParcelGson may not be used to implement an annotation interface; try using AutoAnnotation instead", type);
        }
        AutoParcelTemplateVars vars = new AutoParcelTemplateVars();
        vars.pkg = TypeSimplifier.packageNameOf(type);
        vars.origClass = TypeSimplifier.classNameOf(type);
        vars.simpleClassName = TypeSimplifier.simpleNameOf(vars.origClass);
        vars.subclass = TypeSimplifier.simpleNameOf(this.generatedSubclassName(type));
        this.defineVarsForType(type, vars);
        GwtCompatibility gwtCompatibility = new GwtCompatibility(type);
        vars.gwtCompatibleAnnotation = gwtCompatibility.gwtCompatibleAnnotationString();
        String text = vars.toText();
        text = Reformatter.fixup(text);
        this.writeSourceFile(this.generatedSubclassName(type), text, type);
        GwtSerialization gwtSerialization = new GwtSerialization(gwtCompatibility, this.processingEnv, type);
        gwtSerialization.maybeWriteGwtSerializer(vars);
    }

    private void defineVarsForType(TypeElement type, AutoParcelTemplateVars vars) {
        ImmutableSet<ExecutableElement> toBuilderMethods;
        BuilderSpec builderSpec;
        Optional<BuilderSpec.Builder> builder;
        Types typeUtils = this.processingEnv.getTypeUtils();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        this.findLocalAndInheritedMethods(type, methods);
        AutoParcelProcessor.determineObjectMethodsToGenerate(methods, vars);
        ImmutableSet<ExecutableElement> methodsToImplement = this.methodsToImplement(methods);
        TypeMirrorSet types = new TypeMirrorSet();
        types.addAll(this.returnTypesOf((Iterable<ExecutableElement>)methodsToImplement));
        TypeMirror javaUtilArrays = this.getTypeMirror(Arrays.class);
        if (AutoParcelProcessor.containsArrayType(types)) {
            types.add(javaUtilArrays);
        }
        if ((builder = (builderSpec = new BuilderSpec(type, this.processingEnv, this.errorReporter)).getBuilder()).isPresent()) {
            types.add(this.getTypeMirror(BitSet.class));
            toBuilderMethods = ((BuilderSpec.Builder)builder.get()).toBuilderMethods(typeUtils, (Set<ExecutableElement>)methodsToImplement);
        } else {
            toBuilderMethods = ImmutableSet.of();
        }
        vars.toBuilderMethods = FluentIterable.from((Iterable)toBuilderMethods).transform((Function)SimpleNameFunction.INSTANCE).toList();
        Sets.SetView propertyMethods = Sets.difference(methodsToImplement, (Set)toBuilderMethods);
        String pkg = TypeSimplifier.packageNameOf(type);
        TypeSimplifier typeSimplifier = new TypeSimplifier(typeUtils, pkg, types, type.asType());
        vars.imports = typeSimplifier.typesToImport();
        ArrayList<String> annotations = new ArrayList<String>();
        this.findClassAnnotations(type, typeSimplifier, annotations);
        vars.classAnnotations = annotations;
        vars.arrays = typeSimplifier.simplify(javaUtilArrays);
        vars.bitSet = typeSimplifier.simplifyRaw(this.getTypeMirror(BitSet.class));
        ImmutableMap<ExecutableElement, String> methodToPropertyName = this.methodToPropertyNameMap((Iterable<ExecutableElement>)propertyMethods);
        LinkedHashMap methodToIdentifier = Maps.newLinkedHashMap(methodToPropertyName);
        this.fixReservedIdentifiers(methodToIdentifier);
        ArrayList<Property> props = new ArrayList<Property>();
        for (ExecutableElement method : propertyMethods) {
            String propertyType = typeSimplifier.simplify(method.getReturnType());
            String propertyName = (String)methodToPropertyName.get((Object)method);
            String identifier = (String)methodToIdentifier.get(method);
            props.add(new Property(propertyName, identifier, method, propertyType, typeSimplifier));
        }
        this.eclipseHack().reorderProperties(props);
        vars.props = props;
        vars.serialVersionUID = this.getSerialVersionUID(type);
        vars.formalTypes = typeSimplifier.formalTypeParametersString(type);
        vars.actualTypes = TypeSimplifier.actualTypeParametersString(type);
        vars.wildcardTypes = AutoParcelProcessor.wildcardTypeParametersString(type);
        TypeElement parcelable = this.processingEnv.getElementUtils().getTypeElement("android.os.Parcelable");
        vars.parcelable = parcelable != null && this.processingEnv.getTypeUtils().isAssignable(type.asType(), parcelable.asType());
        if (builder.isPresent()) {
            ((BuilderSpec.Builder)builder.get()).defineVars(vars, typeSimplifier, (Map<ExecutableElement, String>)methodToPropertyName);
        }
    }

    private ImmutableMap<ExecutableElement, String> methodToPropertyNameMap(Iterable<ExecutableElement> propertyMethods) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        boolean allGetters = AutoParcelProcessor.allGetters(propertyMethods);
        for (ExecutableElement method : propertyMethods) {
            String methodName = method.getSimpleName().toString();
            String name = allGetters ? this.nameWithoutPrefix(methodName) : methodName;
            builder.put((Object)method, (Object)name);
        }
        ImmutableMap map = builder.build();
        if (allGetters) {
            this.checkDuplicateGetters((Map<ExecutableElement, String>)map);
        }
        return map;
    }

    private static boolean allGetters(Iterable<ExecutableElement> methods) {
        for (ExecutableElement method : methods) {
            boolean is;
            String name = method.getSimpleName().toString();
            boolean get = name.startsWith("get") && !name.equals("get");
            boolean bl = is = name.startsWith("is") && !name.equals("is") && method.getReturnType().getKind() == TypeKind.BOOLEAN;
            if (get || is) continue;
            return false;
        }
        return true;
    }

    private String nameWithoutPrefix(String name) {
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else {
            assert (name.startsWith("is"));
            name = name.substring(2);
        }
        return Introspector.decapitalize(name);
    }

    private void checkDuplicateGetters(Map<ExecutableElement, String> methodToIdentifier) {
        HashSet seen = Sets.newHashSet();
        for (Map.Entry<ExecutableElement, String> entry : methodToIdentifier.entrySet()) {
            if (seen.add(entry.getValue())) continue;
            this.errorReporter.reportError("More than one @AutoParcelGson property called " + entry.getValue(), entry.getKey());
        }
    }

    private void fixReservedIdentifiers(Map<ExecutableElement, String> methodToIdentifier) {
        for (Map.Entry<ExecutableElement, String> entry : methodToIdentifier.entrySet()) {
            if (!SourceVersion.isKeyword(entry.getValue())) continue;
            entry.setValue(this.disambiguate(entry.getValue(), methodToIdentifier.values()));
        }
    }

    private String disambiguate(String name, Collection<String> existingNames) {
        int i = 0;
        String candidate;
        while (existingNames.contains(candidate = name + i)) {
            ++i;
        }
        return candidate;
    }

    private Set<TypeMirror> returnTypesOf(Iterable<ExecutableElement> methods) {
        TypeMirrorSet returnTypes = new TypeMirrorSet();
        for (ExecutableElement method : methods) {
            returnTypes.add(method.getReturnType());
        }
        return returnTypes;
    }

    private static boolean containsArrayType(Set<TypeMirror> types) {
        for (TypeMirror type : types) {
            if (type.getKind() != TypeKind.ARRAY) continue;
            return true;
        }
        return false;
    }

    private static void determineObjectMethodsToGenerate(List<ExecutableElement> methods, AutoParcelTemplateVars vars) {
        vars.equals = false;
        vars.hashCode = false;
        vars.toString = false;
        for (ExecutableElement method : methods) {
            ObjectMethodToOverride override = AutoParcelProcessor.objectMethodToOverride(method);
            boolean canGenerate = method.getModifiers().contains((Object)Modifier.ABSTRACT) || AutoParcelProcessor.isJavaLangObject((TypeElement)method.getEnclosingElement());
            switch (override) {
                case EQUALS: {
                    vars.equals = canGenerate;
                    break;
                }
                case HASH_CODE: {
                    vars.hashCode = canGenerate;
                    break;
                }
                case TO_STRING: {
                    vars.toString = canGenerate;
                }
            }
        }
    }

    private ImmutableSet<ExecutableElement> methodsToImplement(List<ExecutableElement> methods) {
        ImmutableSet.Builder toImplement = ImmutableSet.builder();
        boolean errors = false;
        for (ExecutableElement method : methods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT) || AutoParcelProcessor.objectMethodToOverride(method) != ObjectMethodToOverride.NONE) continue;
            if (method.getParameters().isEmpty() && method.getReturnType().getKind() != TypeKind.VOID) {
                if (AutoParcelProcessor.isReferenceArrayType(method.getReturnType())) {
                    this.errorReporter.reportError("An AutoParcelGson class cannot define an array-valued property unless it is a primitive array", method);
                    errors = true;
                }
                toImplement.add((Object)method);
                continue;
            }
            this.errorReporter.reportWarning("AutoParcelGson classes cannot have abstract methods other than property getters and Builder converters", method);
        }
        if (errors) {
            throw new AbortProcessingException();
        }
        return toImplement.build();
    }

    private static boolean isReferenceArrayType(TypeMirror type) {
        return type.getKind() == TypeKind.ARRAY && !((ArrayType)type).getComponentType().getKind().isPrimitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSourceFile(String className, String text, TypeElement originatingType) {
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(className, originatingType);
            Writer writer = sourceFile.openWriter();
            try {
                writer.write(text);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not write generated class " + className + ": " + e);
        }
    }

    private boolean ancestorIsAutoParcel(TypeElement type) {
        TypeMirror parentMirror;
        while ((parentMirror = type.getSuperclass()).getKind() != TypeKind.NONE) {
            Types typeUtils = this.processingEnv.getTypeUtils();
            TypeElement parentElement = (TypeElement)typeUtils.asElement(parentMirror);
            if (parentElement.getAnnotation(AutoParcelGson.class) != null) {
                return true;
            }
            type = parentElement;
        }
        return false;
    }

    private boolean implementsAnnotation(TypeElement type) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        return typeUtils.isAssignable(type.asType(), this.getTypeMirror(Annotation.class));
    }

    private String getSerialVersionUID(TypeElement type) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeMirror serializable = this.getTypeMirror(Serializable.class);
        if (typeUtils.isAssignable(type.asType(), serializable)) {
            List<VariableElement> fields = ElementFilter.fieldsIn(type.getEnclosedElements());
            for (VariableElement field : fields) {
                if (!field.getSimpleName().toString().equals("serialVersionUID")) continue;
                Object value = field.getConstantValue();
                if (field.getModifiers().containsAll(Arrays.asList(Modifier.STATIC, Modifier.FINAL)) && field.asType().getKind() == TypeKind.LONG && value != null) {
                    return value + "L";
                }
                this.errorReporter.reportError("serialVersionUID must be a static final long compile-time constant", field);
                break;
            }
        }
        return "";
    }

    private TypeMirror getTypeMirror(Class<?> c) {
        return this.processingEnv.getElementUtils().getTypeElement(c.getName()).asType();
    }

    private static String wildcardTypeParametersString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        return "<" + Joiner.on((String)", ").join((Iterable)FluentIterable.from(typeParameters).transform(Functions.constant((Object)"?"))) + ">";
    }

    private EclipseHack eclipseHack() {
        return new EclipseHack(this.processingEnv);
    }

    private static enum ObjectMethodToOverride {
        NONE,
        TO_STRING,
        EQUALS,
        HASH_CODE,
        DESCRIBE_CONTENTS,
        WRITE_TO_PARCEL;

    }

    public static class Property {
        private final String name;
        private final String identifier;
        private final ExecutableElement method;
        private final String type;
        private final ImmutableList<String> annotations;
        private final ImmutableList<String> fieldAnnotations;

        Property(String name, String identifier, ExecutableElement method, String type, TypeSimplifier typeSimplifier) {
            this.name = name;
            this.identifier = identifier;
            this.method = method;
            this.type = type;
            ImmutableList.Builder annotationsBuilder = ImmutableList.builder();
            ImmutableList.Builder fieldAnnotationsBuilder = ImmutableList.builder();
            this.buildAnnotations(typeSimplifier, (ImmutableList.Builder<String>)annotationsBuilder, (ImmutableList.Builder<String>)fieldAnnotationsBuilder);
            this.annotations = annotationsBuilder.build();
            this.fieldAnnotations = fieldAnnotationsBuilder.build();
        }

        private void buildAnnotations(TypeSimplifier typeSimplifier, ImmutableList.Builder<String> annotationsBuilder, ImmutableList.Builder<String> fieldAnnotationsBuilder) {
            for (AnnotationMirror annotationMirror : this.method.getAnnotationMirrors()) {
                TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (annotationElement.getQualifiedName().toString().equals(Override.class.getName())) continue;
                AnnotationOutput annotationOutput = new AnnotationOutput(typeSimplifier);
                String annotationSource = annotationOutput.sourceFormForAnnotation(annotationMirror);
                boolean foundFieldAnnotation = false;
                for (Map.Entry entry : FIELD_ANNOTATION_MAP.entrySet()) {
                    if (!annotationSource.startsWith((String)entry.getKey())) continue;
                    fieldAnnotationsBuilder.add((Object)annotationSource.replaceFirst((String)entry.getKey(), (String)entry.getValue()));
                    foundFieldAnnotation = true;
                    break;
                }
                if (foundFieldAnnotation) continue;
                annotationsBuilder.add((Object)annotationSource);
            }
        }

        public String toString() {
            return this.identifier;
        }

        public String getName() {
            return this.name;
        }

        public String getGetter() {
            return this.method.getSimpleName().toString();
        }

        TypeElement getOwner() {
            return (TypeElement)this.method.getEnclosingElement();
        }

        TypeMirror getTypeMirror() {
            return this.method.getReturnType();
        }

        public String getType() {
            return this.type;
        }

        public TypeKind getKind() {
            return this.method.getReturnType().getKind();
        }

        public String getCastType() {
            return this.primitive() ? this.box(this.method.getReturnType().getKind()) : this.getType();
        }

        private String box(TypeKind kind) {
            switch (kind) {
                case BOOLEAN: {
                    return "Boolean";
                }
                case BYTE: {
                    return "Byte";
                }
                case SHORT: {
                    return "Short";
                }
                case INT: {
                    return "Integer";
                }
                case LONG: {
                    return "Long";
                }
                case CHAR: {
                    return "Character";
                }
                case FLOAT: {
                    return "Float";
                }
                case DOUBLE: {
                    return "Double";
                }
            }
            throw new RuntimeException("Unknown primitive of kind " + (Object)((Object)kind));
        }

        public boolean primitive() {
            return this.method.getReturnType().getKind().isPrimitive();
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public List<String> getFieldAnnotations() {
            return this.fieldAnnotations;
        }

        public boolean isNullable() {
            for (AnnotationMirror annotationMirror : this.method.getAnnotationMirrors()) {
                String name = annotationMirror.getAnnotationType().asElement().getSimpleName().toString();
                if (!name.equals("Nullable")) continue;
                return true;
            }
            return false;
        }

        public String getAccess() {
            Set<Modifier> mods = this.method.getModifiers();
            if (mods.contains((Object)Modifier.PUBLIC)) {
                return "public ";
            }
            if (mods.contains((Object)Modifier.PROTECTED)) {
                return "protected ";
            }
            return "";
        }
    }
}

