/*
 * Decompiled with CFR 0.152.
 */
package auto.parcelgson.processor;

import auto.parcelgson.AutoParcelGson;
import auto.parcelgson.processor.AutoParcelTemplateVars;
import auto.parcelgson.processor.ErrorReporter;
import auto.parcelgson.processor.SimpleNameFunction;
import auto.parcelgson.processor.TypeMirrorSet;
import auto.parcelgson.processor.TypeSimplifier;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

class BuilderSpec {
    private static final Equivalence<TypeMirror> TYPE_EQUIVALENCE = MoreTypes.equivalence();
    private final TypeElement autoValueClass;
    private final Elements elementUtils;
    private final ErrorReporter errorReporter;
    private static final Set<ElementKind> CLASS_OR_INTERFACE = Sets.immutableEnumSet((Enum)ElementKind.CLASS, (Enum[])new ElementKind[]{ElementKind.INTERFACE});
    private static final TypeVisitor<Element, Void> AS_ELEMENT_VISITOR = new SimpleTypeVisitor6<Element, Void>(){

        @Override
        protected Element defaultAction(TypeMirror e, Void p) {
            throw new IllegalArgumentException(e + "cannot be converted to an Element");
        }

        @Override
        public Element visitDeclared(DeclaredType t, Void p) {
            return t.asElement();
        }

        @Override
        public Element visitError(ErrorType t, Void p) {
            return t.asElement();
        }

        @Override
        public Element visitTypeVariable(TypeVariable t, Void p) {
            return t.asElement();
        }
    };

    BuilderSpec(TypeElement autoValueClass, ProcessingEnvironment processingEnv, ErrorReporter errorReporter) {
        this.autoValueClass = autoValueClass;
        this.elementUtils = processingEnv.getElementUtils();
        this.errorReporter = errorReporter;
    }

    Optional<Builder> getBuilder() {
        Optional builderTypeElement = Optional.absent();
        for (TypeElement containedClass : ElementFilter.typesIn(this.autoValueClass.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent((Element)containedClass, AutoParcelGson.Builder.class)) continue;
            if (!CLASS_OR_INTERFACE.contains((Object)containedClass.getKind())) {
                this.errorReporter.reportError("@AutoParcelGson.Builder can only apply to a class or an interface", containedClass);
                continue;
            }
            if (builderTypeElement.isPresent()) {
                this.errorReporter.reportError(this.autoValueClass + " already has a Builder: " + builderTypeElement.get(), containedClass);
                continue;
            }
            builderTypeElement = Optional.of((Object)containedClass);
        }
        Optional validateMethod = Optional.absent();
        for (ExecutableElement containedMethod : ElementFilter.methodsIn(this.autoValueClass.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent((Element)containedMethod, AutoParcelGson.Validate.class)) continue;
            if (containedMethod.getModifiers().contains((Object)Modifier.STATIC)) {
                this.errorReporter.reportError("@AutoParcelGson.Validate cannot apply to a static method", containedMethod);
                continue;
            }
            if (!containedMethod.getParameters().isEmpty()) {
                this.errorReporter.reportError("@AutoParcelGson.Validate method must not have parameters", containedMethod);
                continue;
            }
            if (containedMethod.getReturnType().getKind() != TypeKind.VOID) {
                this.errorReporter.reportError("Return type of @AutoParcelGson.Validate method must be void", containedMethod);
                continue;
            }
            if (validateMethod.isPresent()) {
                this.errorReporter.reportError("There can only be one @AutoParcelGson.Validate method", containedMethod);
                continue;
            }
            validateMethod = Optional.of((Object)containedMethod);
        }
        if (builderTypeElement.isPresent()) {
            return this.builderFrom((TypeElement)builderTypeElement.get(), (Optional<ExecutableElement>)validateMethod);
        }
        if (validateMethod.isPresent()) {
            this.errorReporter.reportError("@AutoParcelGson.Validate is only meaningful if there is an @AutoParcelGson.Builder", (Element)validateMethod.get());
        }
        return Optional.absent();
    }

    private Optional<Builder> builderFrom(TypeElement builderTypeElement, Optional<ExecutableElement> validateMethod) {
        boolean ok = true;
        int nTypeParameters = this.autoValueClass.getTypeParameters().size();
        if (nTypeParameters != builderTypeElement.getTypeParameters().size()) {
            ok = false;
        } else {
            for (int i = 0; i < nTypeParameters; ++i) {
                TypeMirrorSet builderBounds;
                TypeParameterElement autoValueParam = this.autoValueClass.getTypeParameters().get(i);
                TypeParameterElement builderParam = builderTypeElement.getTypeParameters().get(i);
                if (!autoValueParam.getSimpleName().equals(builderParam.getSimpleName())) {
                    ok = false;
                    break;
                }
                TypeMirrorSet autoValueBounds = new TypeMirrorSet(autoValueParam.getBounds());
                if (autoValueBounds.equals(builderBounds = new TypeMirrorSet(builderParam.getBounds()))) continue;
                ok = false;
                break;
            }
        }
        if (!ok) {
            this.errorReporter.reportError("Type parameters of " + builderTypeElement + " must have same names and bounds as " + "type parameters of " + this.autoValueClass, builderTypeElement);
            return Optional.absent();
        }
        String typeParams = TypeSimplifier.actualTypeParametersString(this.autoValueClass);
        ArrayList<ExecutableElement> buildMethods = new ArrayList<ExecutableElement>();
        ArrayList<ExecutableElement> setterMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : this.abstractMethods(builderTypeElement)) {
            boolean thisOk = false;
            int nParameters = method.getParameters().size();
            if (nParameters == 0 && TYPE_EQUIVALENCE.equivalent((Object)method.getReturnType(), (Object)this.autoValueClass.asType())) {
                buildMethods.add(method);
                thisOk = true;
            } else if (nParameters == 1 && TYPE_EQUIVALENCE.equivalent((Object)method.getReturnType(), (Object)builderTypeElement.asType())) {
                setterMethods.add(method);
                thisOk = true;
            }
            if (thisOk) continue;
            this.errorReporter.reportError("Builder methods must either have no arguments and return " + this.autoValueClass + typeParams + " or have one argument and return " + builderTypeElement + typeParams, method);
            ok = false;
        }
        if (buildMethods.isEmpty()) {
            this.errorReporter.reportError("Builder must have a single no-argument method returning " + this.autoValueClass + typeParams, builderTypeElement);
            ok = false;
        } else if (buildMethods.size() > 1) {
            for (ExecutableElement buildMethod : buildMethods) {
                this.errorReporter.reportError("Builder must have a single no-argument method returning " + this.autoValueClass + typeParams, buildMethod);
            }
            ok = false;
        }
        if (ok) {
            return Optional.of((Object)new Builder(builderTypeElement, (ExecutableElement)Iterables.getOnlyElement(buildMethods), setterMethods, validateMethod));
        }
        return Optional.absent();
    }

    private List<ExecutableElement> abstractMethods(TypeElement typeElement) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        this.addAbstractMethods(typeElement.asType(), methods);
        return methods;
    }

    private void addAbstractMethods(TypeMirror typeMirror, List<ExecutableElement> abstractMethods) {
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return;
        }
        TypeElement typeElement = MoreElements.asType((Element)typeMirror.accept(AS_ELEMENT_VISITOR, null));
        this.addAbstractMethods(typeElement.getSuperclass(), abstractMethods);
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            this.addAbstractMethods(typeMirror2, abstractMethods);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            Iterator<ExecutableElement> it = abstractMethods.iterator();
            while (it.hasNext()) {
                ExecutableElement maybeOverridden = it.next();
                if (!this.elementUtils.overrides(executableElement, maybeOverridden, typeElement)) continue;
                it.remove();
            }
            if (!executableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            abstractMethods.add(executableElement);
        }
    }

    class Builder {
        private final TypeElement builderTypeElement;
        private final ExecutableElement buildMethod;
        private final ImmutableList<ExecutableElement> setters;
        private final Optional<ExecutableElement> validateMethod;

        Builder(TypeElement builderTypeElement, ExecutableElement build, List<ExecutableElement> setters, Optional<ExecutableElement> validateMethod) {
            this.builderTypeElement = builderTypeElement;
            this.buildMethod = build;
            this.setters = ImmutableList.copyOf(setters);
            this.validateMethod = validateMethod;
        }

        ExecutableElement buildMethod() {
            return this.buildMethod;
        }

        private Map<String, ExecutableElement> makeSetterMap(Map<ExecutableElement, String> getterToPropertyName) {
            boolean prefixing;
            TreeMap<String, TypeMirror> getterMap = new TreeMap<String, TypeMirror>();
            for (Map.Entry<ExecutableElement, String> entry : getterToPropertyName.entrySet()) {
                getterMap.put(entry.getValue(), entry.getKey().getReturnType());
            }
            LinkedHashMap noPrefixMap = Maps.newLinkedHashMap();
            LinkedHashMap prefixMap = Maps.newLinkedHashMap();
            boolean ok = true;
            for (ExecutableElement setter : this.setters) {
                LinkedHashMap map = noPrefixMap;
                String name = setter.getSimpleName().toString();
                TypeMirror type = (TypeMirror)getterMap.get(name);
                if (type == null && name.startsWith("set")) {
                    name = Introspector.decapitalize(name.substring(3));
                    type = (TypeMirror)getterMap.get(name);
                    map = prefixMap;
                }
                if (type == null) {
                    BuilderSpec.this.errorReporter.reportError("Method does not correspond to a property of " + BuilderSpec.this.autoValueClass, setter);
                    ok = false;
                    continue;
                }
                VariableElement parameter = (VariableElement)Iterables.getOnlyElement(setter.getParameters());
                if (TYPE_EQUIVALENCE.equivalent((Object)type, (Object)parameter.asType())) {
                    getterMap.remove(name);
                    map.put(name, setter);
                    continue;
                }
                BuilderSpec.this.errorReporter.reportError("Parameter type should be " + type, parameter);
                ok = false;
            }
            if (!ok) {
                return null;
            }
            boolean bl = prefixing = !prefixMap.isEmpty();
            if (prefixing && !noPrefixMap.isEmpty()) {
                BuilderSpec.this.errorReporter.reportError("If any setter methods use the setFoo convention then all must", (Element)noPrefixMap.values().iterator().next());
                return null;
            }
            if (!getterMap.isEmpty()) {
                for (Map.Entry entry : getterMap.entrySet()) {
                    String setterName = prefixing ? this.prefixWithSet((String)entry.getKey()) : (String)entry.getKey();
                    String error = String.format("Expected a method with this signature: %s%s %s(%s)", this.builderTypeElement, TypeSimplifier.actualTypeParametersString(this.builderTypeElement), setterName, entry.getValue());
                    BuilderSpec.this.errorReporter.reportError(error, this.builderTypeElement);
                }
                return null;
            }
            return noPrefixMap.isEmpty() ? prefixMap : noPrefixMap;
        }

        private String prefixWithSet(String propertyName) {
            return "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        }

        ImmutableSet<ExecutableElement> toBuilderMethods(Types typeUtils, Set<ExecutableElement> abstractMethods) {
            ImmutableList builderTypeParamNames = FluentIterable.from(this.builderTypeElement.getTypeParameters()).transform((Function)SimpleNameFunction.INSTANCE).toList();
            ImmutableSet.Builder methods = ImmutableSet.builder();
            for (ExecutableElement method : abstractMethods) {
                if (!this.builderTypeElement.equals(typeUtils.asElement(method.getReturnType()))) continue;
                methods.add((Object)method);
                DeclaredType returnType = MoreTypes.asDeclared((TypeMirror)method.getReturnType());
                ImmutableList.Builder typeArguments = ImmutableList.builder();
                for (TypeMirror typeMirror : returnType.getTypeArguments()) {
                    if (!typeMirror.getKind().equals((Object)TypeKind.TYPEVAR)) continue;
                    typeArguments.add((Object)typeUtils.asElement(typeMirror).getSimpleName().toString());
                }
                if (builderTypeParamNames.equals((Object)typeArguments.build())) continue;
                BuilderSpec.this.errorReporter.reportError("Builder converter method should return " + this.builderTypeElement + TypeSimplifier.actualTypeParametersString(this.builderTypeElement), method);
            }
            ImmutableSet builderMethods = methods.build();
            if (builderMethods.size() > 1) {
                BuilderSpec.this.errorReporter.reportError("There can be at most one builder converter method", (Element)builderMethods.iterator().next());
            }
            return builderMethods;
        }

        void defineVars(AutoParcelTemplateVars vars, TypeSimplifier typeSimplifier, Map<ExecutableElement, String> getterToPropertyName) {
            Map<String, ExecutableElement> propertyNameToSetter = this.makeSetterMap(getterToPropertyName);
            if (propertyNameToSetter == null) {
                return;
            }
            vars.builderIsInterface = this.builderTypeElement.getKind() == ElementKind.INTERFACE;
            vars.builderTypeName = TypeSimplifier.classNameOf(this.builderTypeElement);
            vars.builderFormalTypes = typeSimplifier.formalTypeParametersString(this.builderTypeElement);
            vars.builderActualTypes = TypeSimplifier.actualTypeParametersString(this.builderTypeElement);
            vars.buildMethodName = this.buildMethod.getSimpleName().toString();
            vars.validators = this.validateMethod.isPresent() ? ImmutableSet.of((Object)((ExecutableElement)this.validateMethod.get()).getSimpleName().toString()) : ImmutableSet.of();
            ImmutableMap.Builder setterNameBuilder = ImmutableMap.builder();
            for (Map.Entry<String, ExecutableElement> entry : propertyNameToSetter.entrySet()) {
                setterNameBuilder.put((Object)entry.getKey(), (Object)entry.getValue().getSimpleName().toString());
            }
            vars.builderSetterNames = setterNameBuilder.build();
        }
    }
}

