/*
 * Decompiled with CFR 0.152.
 */
package auto.parcelgson.processor;

import java.io.IOException;
import java.io.Reader;

class JavaTokenizer {
    private final Reader reader;
    private char c;
    private static final char EOF = '\uffff';

    JavaTokenizer(Reader reader) {
        this.reader = reader;
        this.next();
    }

    String nextToken() {
        if (this.c == '\uffff') {
            return null;
        }
        this.skipSpaceAndCommentsAndSlashes();
        if (this.c == '\uffff') {
            return null;
        }
        if (this.c == '\'' || this.c == '\"') {
            this.skipCharacterOrStringLiteral();
            return "0";
        }
        if (this.c == '.') {
            this.next();
            if (!JavaTokenizer.isAsciiDigit(this.c)) {
                return ".";
            }
        }
        if (JavaTokenizer.isAsciiDigit(this.c)) {
            this.skipNumber();
            return "0";
        }
        if (Character.isJavaIdentifierStart(this.c)) {
            return this.identifier();
        }
        char cc = this.c;
        this.next();
        return Character.toString(cc);
    }

    private static boolean isAsciiDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private String identifier() {
        StringBuilder sb = new StringBuilder();
        while (Character.isJavaIdentifierPart(this.c)) {
            sb.append(this.c);
            this.next();
        }
        return sb.toString();
    }

    private void skipNumber() {
        boolean lastWasE = false;
        while (this.c == '.' || Character.isLetterOrDigit(this.c) || lastWasE && (this.c == '+' || this.c == '-')) {
            lastWasE = this.c == 'e' || this.c == 'E';
            this.next();
        }
    }

    private void skipSpaceAndCommentsAndSlashes() {
        while (true) {
            if (Character.isWhitespace(this.c)) {
                this.next();
                continue;
            }
            if (this.c != '/') {
                return;
            }
            this.next();
            switch (this.c) {
                case '/': {
                    this.skipSlashSlashComment();
                    break;
                }
                case '*': {
                    this.skipSlashStarComment();
                }
            }
        }
    }

    private void skipSlashSlashComment() {
        while (this.c != '\n' && this.c != '\r' && this.c != '\uffff') {
            this.next();
        }
    }

    private void skipSlashStarComment() {
        this.next();
        block4: while (true) {
            switch (this.c) {
                case '\uffff': {
                    return;
                }
                case '*': {
                    this.next();
                    if (this.c != '/') continue block4;
                    this.next();
                    return;
                }
            }
            this.next();
        }
    }

    private void skipCharacterOrStringLiteral() {
        char quote = this.c;
        this.next();
        while (this.c != quote && this.c != '\uffff') {
            if (this.c == '\\') {
                this.next();
            }
            this.next();
        }
        this.next();
    }

    private void next() {
        if (this.c == '\uffff') {
            return;
        }
        try {
            int c1 = this.reader.read();
            this.c = c1 < 0 ? (char)65535 : (char)c1;
        }
        catch (IOException e) {
            this.c = (char)65535;
        }
    }
}

