/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.bindingcollectionadapter2;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ObservableList;
import android.databinding.ViewDataBinding;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.lang.ref.WeakReference;
import java.util.List;
import me.tatarka.bindingcollectionadapter2.BindingCollectionAdapter;
import me.tatarka.bindingcollectionadapter2.ItemBinding;
import me.tatarka.bindingcollectionadapter2.Utils;

public class BindingListViewAdapter<T>
extends BaseAdapter
implements BindingCollectionAdapter<T> {
    private final int itemTypeCount;
    private ItemBinding<T> itemBinding;
    private int dropDownItemLayout;
    @NonNull
    private final WeakReferenceOnListChangedCallback<T> callback = new WeakReferenceOnListChangedCallback(this);
    private List<T> items;
    private int[] layouts;
    private LayoutInflater inflater;
    private ItemIds<? super T> itemIds;
    private ItemIsEnabled<? super T> itemIsEnabled;

    public BindingListViewAdapter(int itemTypeCount) {
        this.itemTypeCount = itemTypeCount;
    }

    @Override
    public void setItemBinding(ItemBinding<T> itemBinding) {
        this.itemBinding = itemBinding;
    }

    @Override
    public ItemBinding<T> getItemBinding() {
        return this.itemBinding;
    }

    public void setDropDownItemLayout(int layoutRes) {
        this.dropDownItemLayout = layoutRes;
    }

    @Override
    public void setItems(@Nullable List<T> items) {
        if (this.items == items) {
            return;
        }
        if (this.items instanceof ObservableList) {
            ((ObservableList)this.items).removeOnListChangedCallback(this.callback);
        }
        if (items instanceof ObservableList) {
            ((ObservableList)items).addOnListChangedCallback(this.callback);
        }
        this.items = items;
        this.notifyDataSetChanged();
    }

    @Override
    public T getAdapterItem(int position) {
        return this.items.get(position);
    }

    @Override
    public ViewDataBinding onCreateBinding(LayoutInflater inflater, int layoutRes, ViewGroup viewGroup) {
        return DataBindingUtil.inflate((LayoutInflater)inflater, (int)layoutRes, (ViewGroup)viewGroup, (boolean)false);
    }

    @Override
    public void onBindBinding(ViewDataBinding binding, int variableId, int layoutRes, int position, T item) {
        if (this.itemBinding.bind(binding, item)) {
            binding.executePendingBindings();
        }
    }

    public void setItemIds(@Nullable ItemIds<? super T> itemIds) {
        this.itemIds = itemIds;
    }

    public void setItemIsEnabled(@Nullable ItemIsEnabled<? super T> itemIsEnabled) {
        this.itemIsEnabled = itemIsEnabled;
    }

    public int getCount() {
        return this.items == null ? 0 : this.items.size();
    }

    public T getItem(int position) {
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return this.itemIds == null ? (long)position : this.itemIds.getItemId(position, this.items.get(position));
    }

    public boolean isEnabled(int position) {
        return this.itemIsEnabled == null || this.itemIsEnabled.isEnabled(position, this.items.get(position));
    }

    public final View getView(int position, View convertView, @NonNull ViewGroup parent) {
        if (this.inflater == null) {
            this.inflater = LayoutInflater.from((Context)parent.getContext());
        }
        int viewType = this.getItemViewType(position);
        int layoutRes = this.layouts[viewType];
        ViewDataBinding binding = convertView == null ? this.onCreateBinding(this.inflater, layoutRes, parent) : DataBindingUtil.getBinding((View)convertView);
        T item = this.items.get(position);
        this.onBindBinding(binding, this.itemBinding.variableId(), layoutRes, position, item);
        return binding.getRoot();
    }

    public final View getDropDownView(int position, View convertView, ViewGroup parent) {
        if (this.inflater == null) {
            this.inflater = LayoutInflater.from((Context)parent.getContext());
        }
        if (this.dropDownItemLayout == 0) {
            return super.getDropDownView(position, convertView, parent);
        }
        int layoutRes = this.dropDownItemLayout;
        ViewDataBinding binding = convertView == null ? this.onCreateBinding(this.inflater, layoutRes, parent) : DataBindingUtil.getBinding((View)convertView);
        T item = this.items.get(position);
        this.onBindBinding(binding, this.itemBinding.variableId(), layoutRes, position, item);
        return binding.getRoot();
    }

    public int getItemViewType(int position) {
        this.ensureLayoutsInit();
        T item = this.items.get(position);
        this.itemBinding.onItemBind(position, item);
        int firstEmpty = 0;
        for (int i = 0; i < this.layouts.length; ++i) {
            if (this.itemBinding.layoutRes() == this.layouts[i]) {
                return i;
            }
            if (this.layouts[i] != 0) continue;
            firstEmpty = i;
        }
        this.layouts[firstEmpty] = this.itemBinding.layoutRes();
        return firstEmpty;
    }

    public boolean hasStableIds() {
        return this.itemIds != null;
    }

    public int getViewTypeCount() {
        return this.ensureLayoutsInit();
    }

    private int ensureLayoutsInit() {
        int count = this.itemTypeCount;
        if (this.layouts == null) {
            this.layouts = new int[count];
        }
        return count;
    }

    public static interface ItemIsEnabled<T> {
        public boolean isEnabled(int var1, T var2);
    }

    public static interface ItemIds<T> {
        public long getItemId(int var1, T var2);
    }

    private static class WeakReferenceOnListChangedCallback<T>
    extends ObservableList.OnListChangedCallback<ObservableList<T>> {
        final WeakReference<BindingListViewAdapter<T>> adapterRef;

        WeakReferenceOnListChangedCallback(BindingListViewAdapter<T> adapter) {
            this.adapterRef = new WeakReference<BindingListViewAdapter<BindingListViewAdapter<T>>>(adapter);
        }

        public void onChanged(ObservableList sender) {
            BindingListViewAdapter adapter = (BindingListViewAdapter)this.adapterRef.get();
            if (adapter == null) {
                return;
            }
            Utils.ensureChangeOnMainThread();
            adapter.notifyDataSetChanged();
        }

        public void onItemRangeChanged(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeInserted(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeMoved(ObservableList sender, int fromPosition, int toPosition, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeRemoved(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }
    }
}

