/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.bindingcollectionadapter2;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.databinding.ObservableList;
import android.databinding.ViewDataBinding;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.lang.ref.WeakReference;
import java.util.List;
import me.tatarka.bindingcollectionadapter2.BindingCollectionAdapter;
import me.tatarka.bindingcollectionadapter2.ItemBinding;
import me.tatarka.bindingcollectionadapter2.Utils;

public class BindingViewPagerAdapter<T>
extends PagerAdapter
implements BindingCollectionAdapter<T> {
    private ItemBinding<T> itemBinding;
    private final WeakReferenceOnListChangedCallback<T> callback = new WeakReferenceOnListChangedCallback(this);
    private List<T> items;
    private LayoutInflater inflater;
    private PageTitles<T> pageTitles;

    @Override
    public void setItemBinding(ItemBinding<T> itemBinding) {
        this.itemBinding = itemBinding;
    }

    @Override
    public ItemBinding<T> getItemBinding() {
        return this.itemBinding;
    }

    @Override
    public void setItems(@Nullable List<T> items) {
        if (this.items == items) {
            return;
        }
        if (this.items instanceof ObservableList) {
            ((ObservableList)this.items).removeOnListChangedCallback(this.callback);
        }
        if (items instanceof ObservableList) {
            ((ObservableList)items).addOnListChangedCallback(this.callback);
        }
        this.items = items;
        this.notifyDataSetChanged();
    }

    @Override
    public T getAdapterItem(int position) {
        return this.items.get(position);
    }

    @Override
    public ViewDataBinding onCreateBinding(LayoutInflater inflater, int layoutRes, ViewGroup viewGroup) {
        return DataBindingUtil.inflate((LayoutInflater)inflater, (int)layoutRes, (ViewGroup)viewGroup, (boolean)false);
    }

    @Override
    public void onBindBinding(ViewDataBinding binding, int variableId, int layoutRes, int position, T item) {
        if (this.itemBinding.bind(binding, item)) {
            binding.executePendingBindings();
        }
    }

    public void setPageTitles(@Nullable PageTitles<T> pageTitles) {
        this.pageTitles = pageTitles;
    }

    public int getCount() {
        return this.items == null ? 0 : this.items.size();
    }

    public CharSequence getPageTitle(int position) {
        return this.pageTitles == null ? null : this.pageTitles.getPageTitle(position, this.items.get(position));
    }

    public Object instantiateItem(ViewGroup container, int position) {
        if (this.inflater == null) {
            this.inflater = LayoutInflater.from((Context)container.getContext());
        }
        T item = this.items.get(position);
        this.itemBinding.onItemBind(position, item);
        ViewDataBinding binding = this.onCreateBinding(this.inflater, this.itemBinding.layoutRes(), container);
        this.onBindBinding(binding, this.itemBinding.variableId(), this.itemBinding.layoutRes(), position, item);
        container.addView(binding.getRoot());
        binding.getRoot().setTag(item);
        return binding.getRoot();
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public int getItemPosition(Object object) {
        Object item = ((View)object).getTag();
        if (this.items != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (item != this.items.get(i)) continue;
                return i;
            }
        }
        return -2;
    }

    public static interface PageTitles<T> {
        public CharSequence getPageTitle(int var1, T var2);
    }

    private static class WeakReferenceOnListChangedCallback<T>
    extends ObservableList.OnListChangedCallback<ObservableList<T>> {
        final WeakReference<BindingViewPagerAdapter<T>> adapterRef;

        WeakReferenceOnListChangedCallback(BindingViewPagerAdapter<T> adapter) {
            this.adapterRef = new WeakReference<BindingViewPagerAdapter<BindingViewPagerAdapter<T>>>(adapter);
        }

        public void onChanged(ObservableList sender) {
            BindingViewPagerAdapter adapter = (BindingViewPagerAdapter)this.adapterRef.get();
            if (adapter == null) {
                return;
            }
            Utils.ensureChangeOnMainThread();
            adapter.notifyDataSetChanged();
        }

        public void onItemRangeChanged(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeInserted(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeMoved(ObservableList sender, int fromPosition, int toPosition, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeRemoved(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }
    }
}

