/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.bindingcollectionadapter2;

import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.WrapperListAdapter;
import androidx.annotation.LayoutRes;
import androidx.databinding.BindingAdapter;
import androidx.databinding.BindingConversion;
import androidx.viewpager.widget.ViewPager;
import java.util.List;
import me.tatarka.bindingcollectionadapter2.BindingListViewAdapter;
import me.tatarka.bindingcollectionadapter2.BindingViewPagerAdapter;
import me.tatarka.bindingcollectionadapter2.ItemBinding;
import me.tatarka.bindingcollectionadapter2.OnItemBind;

public class BindingCollectionAdapters {
    @BindingAdapter(value={"itemBinding", "itemTypeCount", "items", "adapter", "itemDropDownLayout", "itemIds", "itemIsEnabled"}, requireAll=false)
    public static <T> void setAdapter(AdapterView adapterView, ItemBinding<T> itemBinding, Integer itemTypeCount, List items, BindingListViewAdapter<T> adapter, @LayoutRes int itemDropDownLayout, BindingListViewAdapter.ItemIds<? super T> itemIds, BindingListViewAdapter.ItemIsEnabled<? super T> itemIsEnabled) {
        if (itemBinding == null) {
            throw new IllegalArgumentException("onItemBind must not be null");
        }
        BindingListViewAdapter<? super T> oldAdapter = (BindingListViewAdapter<? super T>)BindingCollectionAdapters.unwrapAdapter(adapterView.getAdapter());
        if (adapter == null) {
            if (oldAdapter == null) {
                int count = itemTypeCount != null ? itemTypeCount : 1;
                adapter = new BindingListViewAdapter<T>(count);
            } else {
                adapter = oldAdapter;
            }
        }
        adapter.setItemBinding(itemBinding);
        adapter.setDropDownItemLayout(itemDropDownLayout);
        adapter.setItems(items);
        adapter.setItemIds(itemIds);
        adapter.setItemIsEnabled(itemIsEnabled);
        if (oldAdapter != adapter) {
            adapterView.setAdapter(adapter);
        }
    }

    private static Adapter unwrapAdapter(Adapter adapter) {
        return adapter instanceof WrapperListAdapter ? BindingCollectionAdapters.unwrapAdapter((Adapter)((WrapperListAdapter)adapter).getWrappedAdapter()) : adapter;
    }

    @BindingAdapter(value={"itemBinding", "items", "adapter", "pageTitles"}, requireAll=false)
    public static <T> void setAdapter(ViewPager viewPager, ItemBinding<T> itemBinding, List items, BindingViewPagerAdapter<T> adapter, BindingViewPagerAdapter.PageTitles<T> pageTitles) {
        if (itemBinding == null) {
            throw new IllegalArgumentException("onItemBind must not be null");
        }
        BindingViewPagerAdapter<T> oldAdapter = (BindingViewPagerAdapter<T>)viewPager.getAdapter();
        if (adapter == null) {
            adapter = oldAdapter == null ? new BindingViewPagerAdapter<T>() : oldAdapter;
        }
        adapter.setItemBinding(itemBinding);
        adapter.setItems(items);
        adapter.setPageTitles(pageTitles);
        if (oldAdapter != adapter) {
            viewPager.setAdapter(adapter);
        }
    }

    @BindingConversion
    public static <T> ItemBinding<T> toItemBinding(OnItemBind<T> onItemBind) {
        return ItemBinding.of(onItemBind);
    }
}

