/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.bindingcollectionadapter2;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ObservableList;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import java.lang.ref.WeakReference;
import java.util.List;
import me.tatarka.bindingcollectionadapter2.AdapterReferenceCollector;
import me.tatarka.bindingcollectionadapter2.BindingCollectionAdapter;
import me.tatarka.bindingcollectionadapter2.ItemBinding;
import me.tatarka.bindingcollectionadapter2.Utils;

public class BindingListViewAdapter<T>
extends BaseAdapter
implements BindingCollectionAdapter<T> {
    private final int itemTypeCount;
    private ItemBinding<T> itemBinding;
    @LayoutRes
    private int dropDownItemLayout;
    private WeakReferenceOnListChangedCallback<T> callback;
    private List<T> items;
    private int[] layouts;
    private LayoutInflater inflater;
    @Nullable
    private ItemIds<? super T> itemIds;
    @Nullable
    private ItemIsEnabled<? super T> itemIsEnabled;
    @Nullable
    private LifecycleOwner lifecycleOwner;

    public BindingListViewAdapter(int itemTypeCount) {
        this.itemTypeCount = itemTypeCount;
    }

    @Override
    public void setItemBinding(@NonNull ItemBinding<T> itemBinding) {
        this.itemBinding = itemBinding;
    }

    public void setLifecycleOwner(@Nullable LifecycleOwner lifecycleOwner) {
        this.lifecycleOwner = lifecycleOwner;
        this.notifyDataSetChanged();
    }

    @Override
    @NonNull
    public ItemBinding<T> getItemBinding() {
        if (this.itemBinding == null) {
            throw new NullPointerException("itemBinding == null");
        }
        return this.itemBinding;
    }

    public void setDropDownItemLayout(@LayoutRes int layoutRes) {
        this.dropDownItemLayout = layoutRes;
    }

    @Override
    public void setItems(@Nullable List<T> items) {
        if (this.items == items) {
            return;
        }
        if (this.items instanceof ObservableList) {
            ((ObservableList)this.items).removeOnListChangedCallback(this.callback);
            this.callback = null;
        }
        if (items instanceof ObservableList) {
            this.callback = new WeakReferenceOnListChangedCallback(this, (ObservableList)items);
            ((ObservableList)items).addOnListChangedCallback(this.callback);
        }
        this.items = items;
        this.notifyDataSetChanged();
    }

    @Override
    public T getAdapterItem(int position) {
        return this.items.get(position);
    }

    @Override
    @NonNull
    public ViewDataBinding onCreateBinding(@NonNull LayoutInflater inflater, @LayoutRes int layoutRes, @NonNull ViewGroup viewGroup) {
        return DataBindingUtil.inflate((LayoutInflater)inflater, (int)layoutRes, (ViewGroup)viewGroup, (boolean)false);
    }

    @Override
    public void onBindBinding(@NonNull ViewDataBinding binding, int variableId, @LayoutRes int layoutRes, int position, T item) {
        if (this.itemBinding.bind(binding, item)) {
            binding.executePendingBindings();
            if (this.lifecycleOwner != null) {
                binding.setLifecycleOwner(this.lifecycleOwner);
            }
        }
    }

    public void setItemIds(@Nullable ItemIds<? super T> itemIds) {
        this.itemIds = itemIds;
    }

    public void setItemIsEnabled(@Nullable ItemIsEnabled<? super T> itemIsEnabled) {
        this.itemIsEnabled = itemIsEnabled;
    }

    public int getCount() {
        return this.items == null ? 0 : this.items.size();
    }

    public T getItem(int position) {
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return this.itemIds == null ? (long)position : this.itemIds.getItemId(position, this.items.get(position));
    }

    public boolean isEnabled(int position) {
        return this.itemIsEnabled == null || this.itemIsEnabled.isEnabled(position, this.items.get(position));
    }

    public final View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        ViewDataBinding binding;
        if (this.inflater == null) {
            this.inflater = LayoutInflater.from((Context)parent.getContext());
        }
        this.tryGetLifecycleOwner((View)parent);
        int viewType = this.getItemViewType(position);
        int layoutRes = this.layouts[viewType];
        if (convertView == null) {
            binding = this.onCreateBinding(this.inflater, layoutRes, parent);
            binding.getRoot();
        } else {
            binding = DataBindingUtil.getBinding((View)convertView);
        }
        View view = binding.getRoot();
        T item = this.items.get(position);
        this.onBindBinding(binding, this.itemBinding.variableId(), layoutRes, position, item);
        return view;
    }

    public final View getDropDownView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        if (this.inflater == null) {
            this.inflater = LayoutInflater.from((Context)parent.getContext());
        }
        this.tryGetLifecycleOwner((View)parent);
        if (this.dropDownItemLayout == 0) {
            return super.getDropDownView(position, convertView, parent);
        }
        int layoutRes = this.dropDownItemLayout;
        ViewDataBinding binding = convertView == null ? this.onCreateBinding(this.inflater, layoutRes, parent) : DataBindingUtil.getBinding((View)convertView);
        View view = binding.getRoot();
        T item = this.items.get(position);
        this.onBindBinding(binding, this.itemBinding.variableId(), layoutRes, position, item);
        return view;
    }

    private void tryGetLifecycleOwner(View view) {
        if (this.lifecycleOwner == null || this.lifecycleOwner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            this.lifecycleOwner = Utils.findLifecycleOwner(view);
        }
    }

    public int getItemViewType(int position) {
        this.ensureLayoutsInit();
        T item = this.items.get(position);
        this.itemBinding.onItemBind(position, item);
        int firstEmpty = 0;
        for (int i = 0; i < this.layouts.length; ++i) {
            if (this.itemBinding.layoutRes() == this.layouts[i]) {
                return i;
            }
            if (this.layouts[i] != 0) continue;
            firstEmpty = i;
        }
        this.layouts[firstEmpty] = this.itemBinding.layoutRes();
        return firstEmpty;
    }

    public boolean hasStableIds() {
        return this.itemIds != null;
    }

    public int getViewTypeCount() {
        return this.ensureLayoutsInit();
    }

    private int ensureLayoutsInit() {
        int count = this.itemTypeCount;
        if (this.layouts == null) {
            this.layouts = new int[count];
        }
        return count;
    }

    public static interface ItemIsEnabled<T> {
        public boolean isEnabled(int var1, T var2);
    }

    public static interface ItemIds<T> {
        public long getItemId(int var1, T var2);
    }

    static class WeakReferenceOnListChangedCallback<T>
    extends ObservableList.OnListChangedCallback<ObservableList<T>> {
        final WeakReference<BindingListViewAdapter<T>> adapterRef;

        WeakReferenceOnListChangedCallback(BindingListViewAdapter<T> adapter, ObservableList<T> items) {
            this.adapterRef = AdapterReferenceCollector.createRef(adapter, items, this);
        }

        public void onChanged(ObservableList sender) {
            BindingListViewAdapter adapter = (BindingListViewAdapter)this.adapterRef.get();
            if (adapter == null) {
                return;
            }
            Utils.ensureChangeOnMainThread();
            adapter.notifyDataSetChanged();
        }

        public void onItemRangeChanged(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeInserted(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeMoved(ObservableList sender, int fromPosition, int toPosition, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeRemoved(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }
    }
}

