/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.bindingcollectionadapter2;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ObservableList;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.viewpager.widget.PagerAdapter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import me.tatarka.bindingcollectionadapter2.AdapterReferenceCollector;
import me.tatarka.bindingcollectionadapter2.BindingCollectionAdapter;
import me.tatarka.bindingcollectionadapter2.ItemBinding;
import me.tatarka.bindingcollectionadapter2.Utils;

public class BindingViewPagerAdapter<T>
extends PagerAdapter
implements BindingCollectionAdapter<T> {
    private ItemBinding<T> itemBinding;
    private WeakReferenceOnListChangedCallback<T> callback;
    private List<T> items;
    private LayoutInflater inflater;
    @Nullable
    private PageTitles<T> pageTitles;
    @Nullable
    private LifecycleOwner lifecycleOwner;
    private List<View> views = new ArrayList<View>();

    @Override
    public void setItemBinding(@NonNull ItemBinding<T> itemBinding) {
        this.itemBinding = itemBinding;
    }

    public void setLifecycleOwner(@Nullable LifecycleOwner lifecycleOwner) {
        this.lifecycleOwner = lifecycleOwner;
        for (View view : this.views) {
            ViewDataBinding binding = DataBindingUtil.getBinding((View)view);
            if (binding == null) continue;
            binding.setLifecycleOwner(lifecycleOwner);
        }
    }

    @Override
    @NonNull
    public ItemBinding<T> getItemBinding() {
        if (this.itemBinding == null) {
            throw new NullPointerException("itemBinding == null");
        }
        return this.itemBinding;
    }

    @Override
    public void setItems(@Nullable List<T> items) {
        if (this.items == items) {
            return;
        }
        if (this.items instanceof ObservableList) {
            ((ObservableList)this.items).removeOnListChangedCallback(this.callback);
            this.callback = null;
        }
        if (items instanceof ObservableList) {
            this.callback = new WeakReferenceOnListChangedCallback(this, (ObservableList)items);
            ((ObservableList)items).addOnListChangedCallback(this.callback);
        }
        this.items = items;
        this.notifyDataSetChanged();
    }

    @Override
    public T getAdapterItem(int position) {
        return this.items.get(position);
    }

    @Override
    @NonNull
    public ViewDataBinding onCreateBinding(@NonNull LayoutInflater inflater, @LayoutRes int layoutRes, @NonNull ViewGroup viewGroup) {
        return DataBindingUtil.inflate((LayoutInflater)inflater, (int)layoutRes, (ViewGroup)viewGroup, (boolean)false);
    }

    @Override
    public void onBindBinding(@NonNull ViewDataBinding binding, int variableId, @LayoutRes int layoutRes, int position, T item) {
        if (this.itemBinding.bind(binding, item)) {
            binding.executePendingBindings();
            if (this.lifecycleOwner != null) {
                binding.setLifecycleOwner(this.lifecycleOwner);
            }
        }
    }

    public void setPageTitles(@Nullable PageTitles<T> pageTitles) {
        this.pageTitles = pageTitles;
    }

    public int getCount() {
        return this.items == null ? 0 : this.items.size();
    }

    @Nullable
    public CharSequence getPageTitle(int position) {
        return this.pageTitles == null ? null : this.pageTitles.getPageTitle(position, this.items.get(position));
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        if (this.inflater == null) {
            this.inflater = LayoutInflater.from((Context)container.getContext());
        }
        this.tryGetLifecycleOwner((View)container);
        T item = this.items.get(position);
        this.itemBinding.onItemBind(position, item);
        ViewDataBinding binding = this.onCreateBinding(this.inflater, this.itemBinding.layoutRes(), container);
        View view = binding.getRoot();
        this.onBindBinding(binding, this.itemBinding.variableId(), this.itemBinding.layoutRes(), position, item);
        container.addView(view);
        view.setTag(item);
        this.views.add(view);
        return view;
    }

    private void tryGetLifecycleOwner(View view) {
        if (this.lifecycleOwner == null || this.lifecycleOwner.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            this.lifecycleOwner = Utils.findLifecycleOwner(view);
        }
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        View view = (View)object;
        this.views.remove(view);
        container.removeView(view);
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public int getItemPosition(@NonNull Object object) {
        Object item = ((View)object).getTag();
        if (this.items != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (item != this.items.get(i)) continue;
                return i;
            }
        }
        return -2;
    }

    public static interface PageTitles<T> {
        @Nullable
        public CharSequence getPageTitle(int var1, T var2);
    }

    private static class WeakReferenceOnListChangedCallback<T>
    extends ObservableList.OnListChangedCallback<ObservableList<T>> {
        final WeakReference<BindingViewPagerAdapter<T>> adapterRef;

        WeakReferenceOnListChangedCallback(BindingViewPagerAdapter<T> adapter, ObservableList<T> items) {
            this.adapterRef = AdapterReferenceCollector.createRef(adapter, items, this);
        }

        public void onChanged(ObservableList sender) {
            BindingViewPagerAdapter adapter = (BindingViewPagerAdapter)this.adapterRef.get();
            if (adapter == null) {
                return;
            }
            Utils.ensureChangeOnMainThread();
            adapter.notifyDataSetChanged();
        }

        public void onItemRangeChanged(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeInserted(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeMoved(ObservableList sender, int fromPosition, int toPosition, int itemCount) {
            this.onChanged(sender);
        }

        public void onItemRangeRemoved(ObservableList sender, int positionStart, int itemCount) {
            this.onChanged(sender);
        }
    }
}

