/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.bindingcollectionadapter2;

import android.content.Context;
import android.content.res.Resources;
import android.os.Looper;
import android.view.View;
import androidx.annotation.LayoutRes;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.LifecycleOwner;

class Utils {
    private static final String TAG = "BCAdapters";

    Utils() {
    }

    static void throwMissingVariable(ViewDataBinding binding, int bindingVariable, @LayoutRes int layoutRes) {
        Context context = binding.getRoot().getContext();
        Resources resources = context.getResources();
        String layoutName = resources.getResourceName(layoutRes);
        String bindingVariableName = DataBindingUtil.convertBrIdToString((int)bindingVariable);
        throw new IllegalStateException("Could not bind variable '" + bindingVariableName + "' in layout '" + layoutName + "'");
    }

    @Nullable
    @MainThread
    static LifecycleOwner findLifecycleOwner(View view) {
        ViewDataBinding binding = DataBindingUtil.findBinding((View)view);
        LifecycleOwner lifecycleOwner = null;
        if (binding != null) {
            lifecycleOwner = binding.getLifecycleOwner();
        }
        Context ctx = view.getContext();
        if (lifecycleOwner == null && ctx instanceof LifecycleOwner) {
            lifecycleOwner = (LifecycleOwner)ctx;
        }
        return lifecycleOwner;
    }

    static void ensureChangeOnMainThread() {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new IllegalStateException("You must only modify the ObservableList on the main thread.");
        }
    }
}

