/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.bindingcollectionadapter2.itembindings;

import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import me.tatarka.bindingcollectionadapter2.ItemBinding;
import me.tatarka.bindingcollectionadapter2.OnItemBind;

public class OnItemBindClass<T>
implements OnItemBind<T> {
    private final List<Class<? extends T>> itemBindingClassList = new ArrayList<Class<? extends T>>(2);
    private final List<OnItemBind<? extends T>> itemBindingList = new ArrayList<OnItemBind<? extends T>>(2);

    public OnItemBindClass<T> map(@NonNull Class<? extends T> itemClass, int variableId, @LayoutRes int layoutRes) {
        int index = this.itemBindingClassList.indexOf(itemClass);
        if (index >= 0) {
            this.itemBindingList.set(index, this.itemBind(variableId, layoutRes));
        } else {
            this.itemBindingClassList.add(itemClass);
            this.itemBindingList.add(this.itemBind(variableId, layoutRes));
        }
        return this;
    }

    public <E extends T> OnItemBindClass<T> map(@NonNull Class<E> itemClass, @NonNull OnItemBind<E> onItemBind) {
        int index = this.itemBindingClassList.indexOf(itemClass);
        if (index >= 0) {
            this.itemBindingList.set(index, onItemBind);
        } else {
            this.itemBindingClassList.add(itemClass);
            this.itemBindingList.add(onItemBind);
        }
        return this;
    }

    public int itemTypeCount() {
        return this.itemBindingClassList.size();
    }

    @Override
    public void onItemBind(@NonNull ItemBinding itemBinding, int position, T item) {
        for (int i = 0; i < this.itemBindingClassList.size(); ++i) {
            Class<T> key = this.itemBindingClassList.get(i);
            if (!key.isInstance(item)) continue;
            OnItemBind<T> itemBind = this.itemBindingList.get(i);
            itemBind.onItemBind(itemBinding, position, item);
            return;
        }
        throw new IllegalArgumentException("Missing class for item " + item);
    }

    @NonNull
    private OnItemBind<T> itemBind(final int variableId, final @LayoutRes int layoutRes) {
        return new OnItemBind<T>(){

            @Override
            public void onItemBind(@NonNull ItemBinding itemBinding, int position, T item) {
                itemBinding.set(variableId, layoutRes);
            }
        };
    }
}

