/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.bindingcollectionadapter2;

import androidx.databinding.ObservableList;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import me.tatarka.bindingcollectionadapter2.BindingCollectionAdapter;

class AdapterReferenceCollector {
    static final ReferenceQueue<Object> QUEUE = new ReferenceQueue();
    static PollReferenceThread thread;

    AdapterReferenceCollector() {
    }

    static <T, A extends BindingCollectionAdapter<T>> WeakReference<A> createRef(A adapter, ObservableList<T> items, ObservableList.OnListChangedCallback callback) {
        if (thread == null || !thread.isAlive()) {
            thread = new PollReferenceThread();
            thread.start();
        }
        return new AdapterRef<T, A>(adapter, items, callback);
    }

    static class AdapterRef<T, A extends BindingCollectionAdapter<T>>
    extends WeakReference<A> {
        private final ObservableList<T> items;
        private final ObservableList.OnListChangedCallback callback;

        AdapterRef(A referent, ObservableList<T> items, ObservableList.OnListChangedCallback callback) {
            super(referent, QUEUE);
            this.items = items;
            this.callback = callback;
        }

        void unregister() {
            this.items.removeOnListChangedCallback(this.callback);
        }
    }

    private static class PollReferenceThread
    extends Thread {
        private PollReferenceThread() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Reference<Object> ref;
                    if (!((ref = QUEUE.remove()) instanceof AdapterRef)) {
                        continue;
                    }
                    ((AdapterRef)ref).unregister();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

