/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.bindingcollectionadapter2.collections;

import androidx.annotation.NonNull;
import androidx.databinding.ListChangeRegistry;
import androidx.databinding.ObservableList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MergeObservableList<T>
extends AbstractList<T>
implements ObservableList<T> {
    private final ArrayList<List<? extends T>> lists = new ArrayList();
    private final ListChangeCallback callback = new ListChangeCallback();
    private final ListChangeRegistry listeners = new ListChangeRegistry();

    public void addOnListChangedCallback(@NonNull ObservableList.OnListChangedCallback<? extends ObservableList<T>> listener) {
        this.listeners.add(listener);
    }

    public void removeOnListChangedCallback(@NonNull ObservableList.OnListChangedCallback<? extends ObservableList<T>> listener) {
        this.listeners.remove(listener);
    }

    public MergeObservableList<T> insertItem(T object) {
        this.lists.add(Collections.singletonList(object));
        ++this.modCount;
        this.listeners.notifyInserted((ObservableList)this, this.size() - 1, 1);
        return this;
    }

    public MergeObservableList<T> insertList(@NonNull ObservableList<? extends T> list) {
        list.addOnListChangedCallback((ObservableList.OnListChangedCallback)this.callback);
        int oldSize = this.size();
        this.lists.add((List<T>)list);
        ++this.modCount;
        if (!list.isEmpty()) {
            this.listeners.notifyInserted((ObservableList)this, oldSize, list.size());
        }
        return this;
    }

    public boolean removeItem(T object) {
        int size = 0;
        int listsSize = this.lists.size();
        for (int i = 0; i < listsSize; ++i) {
            List<T> list = this.lists.get(i);
            if (!(list instanceof ObservableList)) {
                T item = list.get(0);
                if (object == null ? item == null : object.equals(item)) {
                    this.lists.remove(i);
                    ++this.modCount;
                    this.listeners.notifyRemoved((ObservableList)this, size, 1);
                    return true;
                }
            }
            size += list.size();
        }
        return false;
    }

    public boolean removeList(@NonNull ObservableList<? extends T> listToRemove) {
        int size = 0;
        int listsSize = this.lists.size();
        for (int i = 0; i < listsSize; ++i) {
            List<T> list = this.lists.get(i);
            if (list == listToRemove) {
                listToRemove.removeOnListChangedCallback((ObservableList.OnListChangedCallback)this.callback);
                this.lists.remove(i);
                ++this.modCount;
                this.listeners.notifyRemoved((ObservableList)this, size, list.size());
                return true;
            }
            size += list.size();
        }
        return false;
    }

    public void removeAll() {
        int size = this.size();
        int listSize = this.lists.size();
        for (int i = 0; i < listSize; ++i) {
            List<? extends T> list = this.lists.get(i);
            if (!(list instanceof ObservableList)) continue;
            ((ObservableList)list).removeOnListChangedCallback((ObservableList.OnListChangedCallback)this.callback);
        }
        this.lists.clear();
        ++this.modCount;
        if (size > 0) {
            this.listeners.notifyRemoved((ObservableList)this, 0, size);
        }
    }

    public int mergeToBackingIndex(@NonNull ObservableList<? extends T> backingList, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int size = 0;
        int listsSize = this.lists.size();
        for (int i = 0; i < listsSize; ++i) {
            List<T> list = this.lists.get(i);
            if (backingList == list) {
                if (index < list.size()) {
                    return size + index;
                }
                throw new IndexOutOfBoundsException();
            }
            size += list.size();
        }
        throw new IllegalArgumentException();
    }

    public int backingIndexToMerge(@NonNull ObservableList<? extends T> backingList, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int size = 0;
        int listsSize = this.lists.size();
        for (int i = 0; i < listsSize; ++i) {
            List<T> list = this.lists.get(i);
            if (backingList == list) {
                if (index - size < list.size()) {
                    return index - size;
                }
                throw new IndexOutOfBoundsException();
            }
            size += list.size();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public T get(int location) {
        if (location < 0) {
            throw new IndexOutOfBoundsException();
        }
        int size = 0;
        int listsSize = this.lists.size();
        for (int i = 0; i < listsSize; ++i) {
            List<T> list = this.lists.get(i);
            if (location - size < list.size()) {
                return list.get(location - size);
            }
            size += list.size();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        int size = 0;
        int listsSize = this.lists.size();
        for (int i = 0; i < listsSize; ++i) {
            List<T> list = this.lists.get(i);
            size += list.size();
        }
        return size;
    }

    static /* synthetic */ int access$000(MergeObservableList x0) {
        return x0.modCount;
    }

    static /* synthetic */ int access$500(MergeObservableList x0) {
        return x0.modCount;
    }

    static /* synthetic */ int access$800(MergeObservableList x0) {
        return x0.modCount;
    }

    class ListChangeCallback
    extends ObservableList.OnListChangedCallback {
        ListChangeCallback() {
        }

        public void onChanged(ObservableList sender) {
            MergeObservableList.this.modCount = MergeObservableList.this.modCount + 1;
            MergeObservableList.this.listeners.notifyChanged((ObservableList)MergeObservableList.this);
        }

        public void onItemRangeChanged(ObservableList sender, int positionStart, int itemCount) {
            int size = 0;
            int listsSize = MergeObservableList.this.lists.size();
            for (int i = 0; i < listsSize; ++i) {
                List list = (List)MergeObservableList.this.lists.get(i);
                if (list == sender) {
                    MergeObservableList.this.listeners.notifyChanged((ObservableList)MergeObservableList.this, size + positionStart, itemCount);
                    return;
                }
                size += list.size();
            }
        }

        public void onItemRangeInserted(ObservableList sender, int positionStart, int itemCount) {
            MergeObservableList.this.modCount = MergeObservableList.this.modCount + 1;
            int size = 0;
            int listsSize = MergeObservableList.this.lists.size();
            for (int i = 0; i < listsSize; ++i) {
                List list = (List)MergeObservableList.this.lists.get(i);
                if (list == sender) {
                    MergeObservableList.this.listeners.notifyInserted((ObservableList)MergeObservableList.this, size + positionStart, itemCount);
                    return;
                }
                size += list.size();
            }
        }

        public void onItemRangeMoved(ObservableList sender, int fromPosition, int toPosition, int itemCount) {
            int size = 0;
            int listsSize = MergeObservableList.this.lists.size();
            for (int i = 0; i < listsSize; ++i) {
                List list = (List)MergeObservableList.this.lists.get(i);
                if (list == sender) {
                    MergeObservableList.this.listeners.notifyMoved((ObservableList)MergeObservableList.this, size + fromPosition, size + toPosition, itemCount);
                    return;
                }
                size += list.size();
            }
        }

        public void onItemRangeRemoved(ObservableList sender, int positionStart, int itemCount) {
            MergeObservableList.this.modCount = MergeObservableList.this.modCount + 1;
            int size = 0;
            int listsSize = MergeObservableList.this.lists.size();
            for (int i = 0; i < listsSize; ++i) {
                List list = (List)MergeObservableList.this.lists.get(i);
                if (list == sender) {
                    MergeObservableList.this.listeners.notifyRemoved((ObservableList)MergeObservableList.this, size + positionStart, itemCount);
                    return;
                }
                size += list.size();
            }
        }
    }
}

