/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.loader;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Loader<T> {
    private static final int STATE_RUNNING = 1;
    private static final int STATE_HAS_RESULT = 2;
    private static final int STATE_COMPLETED = 4;
    private static final int STATE_DESTROYED = 8;
    private static final int CALLBACKS_START = 1;
    private static final int CALLBACKS_RESULT = 2;
    private static final int CALLBACKS_COMPLETE = 4;
    @Nullable
    private Callbacks<T> callbacks;
    @Nullable
    private Receiver receiver;
    private T cachedResult;
    private AtomicInteger state = new AtomicInteger();
    private final Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            int callback = msg.arg1;
            HandlerArgs args = (HandlerArgs)msg.obj;
            if ((callback & 2) == 2) {
                args.callbacks.onLoaderResult(args.cachedResult);
            } else if ((callback & 1) == 1) {
                args.callbacks.onLoaderStart();
            }
            if ((callback & 4) == 4) {
                args.callbacks.onLoaderComplete();
            }
        }
    };

    private static boolean isRunning(int state) {
        return (state & 1) == 1;
    }

    private static boolean isCompleted(int state) {
        return (state & 4) == 4;
    }

    private static void checkDestroyed(String method, int state) {
        if ((state & 8) == 8) {
            throw new IllegalStateException("cannot call " + method + "() after destroy()");
        }
    }

    @MainThread
    public final void start() {
        int s = this.state.get();
        Loader.checkDestroyed("start", s);
        if (!Loader.isRunning(s) && !Loader.isCompleted(s)) {
            this.state.set(1);
            if (this.callbacks != null) {
                this.callbacks.onLoaderStart();
            }
            Receiver receiver = this.receiver = new Receiver();
            receiver.myState = receiver.myState | 4;
            this.onStart(this.receiver);
            receiver = this.receiver;
            receiver.myState = receiver.myState & 0xFFFFFFFB;
        }
    }

    @MainThread
    public final void cancel() {
        int s = this.state.get();
        Loader.checkDestroyed("cancel", s);
        this.cachedResult = null;
        if (this.receiver != null) {
            this.receiver.myState = 1;
            this.receiver = null;
        }
        this.handler.removeMessages(0);
        if (Loader.isRunning(s)) {
            this.onCancel();
        }
        this.state.set(0);
    }

    @MainThread
    public final void restart() {
        this.cancel();
        this.start();
    }

    @MainThread
    public final void destroy() {
        int s = this.state.get();
        Loader.checkDestroyed("destroy", s);
        this.cancel();
        this.state.set(8);
        this.callbacks = null;
        this.onDestroy();
    }

    public final boolean isRunning() {
        return Loader.isRunning(this.state.get());
    }

    public final boolean hasResult() {
        return (this.state.get() & 2) == 2;
    }

    public final boolean isCompleted() {
        return Loader.isCompleted(this.state.get());
    }

    public final boolean isAttached() {
        return this.callbacks != null;
    }

    protected abstract void onStart(Receiver var1);

    protected void onCancel() {
    }

    protected void onDestroy() {
    }

    @MainThread
    public final void setCallbacks(@Nullable Callbacks<T> callbacks) {
        this.callbacks = callbacks;
        this.handler.removeMessages(0);
        if (callbacks != null) {
            int methods = 0;
            if (this.hasResult()) {
                methods |= 2;
            } else if (this.isRunning()) {
                methods |= 1;
            }
            if (this.isCompleted()) {
                methods |= 4;
            }
            this.dispatchCallbacks(callbacks, methods);
        }
    }

    private void dispatchCallbacks(Callbacks<T> callbacks, int methods) {
        Message message = this.handler.obtainMessage(0);
        message.obj = new HandlerArgs(this.cachedResult, callbacks);
        message.arg1 = methods;
        this.handler.dispatchMessage(message);
    }

    private static final class HandlerArgs<T> {
        final T cachedResult;
        final Callbacks<T> callbacks;

        private HandlerArgs(T cachedResult, Callbacks<T> callbacks) {
            this.cachedResult = cachedResult;
            this.callbacks = callbacks;
        }
    }

    public static abstract class CallbacksAdapter<T>
    implements Callbacks<T> {
        @Override
        public void onLoaderStart() {
        }

        @Override
        public void onLoaderResult(T result) {
        }

        @Override
        public void onLoaderComplete() {
        }
    }

    public static interface Callbacks<T> {
        public void onLoaderStart();

        public void onLoaderResult(T var1);

        public void onLoaderComplete();
    }

    public final class Receiver {
        private static final int CANCELED = 1;
        private static final int COMPLETE = 2;
        private static final int SYNCHRONOUS = 4;
        private int myState = 0;

        @MainThread
        public final void deliverResult(T result) {
            if ((this.myState & 1) == 1) {
                return;
            }
            if ((this.myState & 2) == 2) {
                throw new IllegalStateException("cannot deliver result after complete()");
            }
            int s = Loader.this.state.get();
            Loader.this.state.set(s | 2);
            Loader.this.cachedResult = result;
            if (Loader.this.callbacks != null) {
                if ((this.myState & 4) == 4) {
                    Loader.this.dispatchCallbacks(Loader.this.callbacks, 2);
                } else {
                    Loader.this.callbacks.onLoaderResult(result);
                }
            }
        }

        @MainThread
        public final void complete() {
            if ((this.myState & 1) == 1) {
                return;
            }
            if ((this.myState & 2) == 2) {
                throw new IllegalStateException("complete() already called");
            }
            this.myState = 2;
            int s = Loader.this.state.get();
            Loader.this.state.set(s & 0xFFFFFFFE | 4);
            if (Loader.this.callbacks != null) {
                if ((this.myState & 4) == 4) {
                    Loader.this.dispatchCallbacks(Loader.this.callbacks, 4);
                } else {
                    Loader.this.callbacks.onLoaderComplete();
                }
            }
        }
    }
}

