/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.loader;

import android.util.SparseArray;
import me.tatarka.loader.Loader;
import me.tatarka.retainstate.RetainState;

public class LoaderManager {
    public static final RetainState.OnCreate<LoaderManager> CREATE = new RetainState.OnCreate<LoaderManager>(){

        public LoaderManager onCreate() {
            return new LoaderManager();
        }
    };
    private SparseArray<Loader<?>> loaders = new SparseArray(1);

    public <T, L extends Loader<T>> L init(int id, RetainState.OnCreate<L> create, Loader.Callbacks<T> callbacks) {
        Loader loader = (Loader)this.loaders.get(id);
        if (loader == null) {
            loader = (Loader)create.onCreate();
            this.loaders.put(id, (Object)loader);
        }
        if (loader.isAttached()) {
            throw new IllegalStateException("Loader " + loader + " already has callbacks. Make sure you are using unique ids and that you are calling either detach() or destroy() when the Activity is destroyed.");
        }
        loader.setCallbacks(callbacks);
        return (L)loader;
    }

    public void remove(int id) {
        Loader loader = (Loader)this.loaders.get(id);
        if (loader != null) {
            loader.setCallbacks(null);
            loader.destroy();
            this.loaders.remove(id);
        }
    }

    public void detach() {
        int size = this.loaders.size();
        for (int i = 0; i < size; ++i) {
            Loader loader = (Loader)this.loaders.get(i);
            if (loader == null) continue;
            loader.setCallbacks(null);
        }
    }

    public void destroy() {
        int size = this.loaders.size();
        for (int i = 0; i < size; ++i) {
            Loader loader = (Loader)this.loaders.get(i);
            if (loader == null) continue;
            loader.destroy();
        }
        this.loaders.clear();
    }

    public void onDestroy(RetainState retainState) {
        if (retainState.isRetaining()) {
            this.detach();
        } else {
            this.destroy();
        }
    }
}

