/*
 * Decompiled with CFR 0.152.
 */
package me.tatarka.shard.pager;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.savedstate.SavedStateRegistry;
import androidx.viewpager.widget.PagerAdapter;
import me.tatarka.shard.activity.ActivityCallbacks;
import me.tatarka.shard.app.Shard;
import me.tatarka.shard.app.ShardManager;
import me.tatarka.shard.app.ShardOwner;
import me.tatarka.shard.app.ShardOwnerContextWrapper;
import me.tatarka.shard.app.ShardOwners;
import me.tatarka.shard.content.ComponentCallbacks;

public abstract class ShardPagerAdapter
extends PagerAdapter {
    private static final String STATE_SHARDS = "shards";
    private final ShardOwner owner;
    private int primaryPage = -1;
    private SparseArray<Page> pages = new SparseArray();
    private SparseArray<Shard.State> pageState = new SparseArray();

    public ShardPagerAdapter(Context context) {
        this(ShardOwners.get((Context)context));
    }

    public ShardPagerAdapter(ShardOwner owner) {
        this.owner = owner;
    }

    @NonNull
    @CallSuper
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        Shard.State state = (Shard.State)this.pageState.get(position);
        Shard shard = this.getItem(position);
        Page page = new Page(this.owner, container, shard, state);
        this.pages.put(position, (Object)page);
        return page;
    }

    @CallSuper
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        Page page = (Page)object;
        if (this.pages.indexOfKey(position) >= 0) {
            this.pages.remove(position);
            this.pageState.put(position, (Object)page.saveState());
        }
        page.destroy();
    }

    public final int getItemPosition(@NonNull Object object) {
        Page page = (Page)object;
        int position = this.getItemPosition(page.shard);
        if (position == -1) {
            return position;
        }
        int index = this.pages.indexOfValue((Object)page);
        this.pages.removeAt(index);
        if (position != -2) {
            this.pages.put(position, (Object)page);
        }
        return position;
    }

    public int getItemPosition(Shard shard) {
        return -1;
    }

    @CallSuper
    public void setPrimaryItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        if (position != this.primaryPage) {
            if (this.primaryPage != -1) {
                ((Page)this.pages.get(this.primaryPage)).setPrimary(false);
            }
            Page page = (Page)object;
            page.setPrimary(true);
            this.primaryPage = position;
        }
    }

    @NonNull
    public abstract Shard getItem(int var1);

    public final boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == ((Page)object).shard.getView();
    }

    @CallSuper
    public void restoreState(Parcelable state, @Nullable ClassLoader loader) {
        Bundle bundle = (Bundle)state;
        bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.pageState = bundle.getSparseParcelableArray(STATE_SHARDS);
    }

    @CallSuper
    public Parcelable saveState() {
        Bundle state = new Bundle();
        for (int i = 0; i < this.pages.size(); ++i) {
            this.pageState.put(this.pages.keyAt(i), (Object)((Page)this.pages.valueAt(i)).saveState());
        }
        state.putSparseParcelableArray(STATE_SHARDS, this.pageState);
        return state;
    }

    static class Page
    implements ShardOwner,
    LifecycleEventObserver {
        private final ShardOwner parentOwner;
        private final Context context;
        private final LifecycleRegistry lifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);
        private final ShardManager fm;
        final Shard shard;
        private boolean isPrimary;
        private boolean isReallyResumed;

        Page(ShardOwner parentOwner, ViewGroup container, Shard shard, @Nullable Shard.State state) {
            this.parentOwner = parentOwner;
            this.context = new ShardOwnerContextWrapper(container.getContext(), (ViewModelStoreOwner)this);
            this.shard = shard;
            this.fm = new ShardManager((ShardOwner)this);
            this.fm.restoreState(shard, state);
            this.fm.add(shard, container);
            parentOwner.getLifecycle().addObserver((LifecycleObserver)this);
        }

        void destroy() {
            this.parentOwner.getLifecycle().removeObserver((LifecycleObserver)this);
            this.fm.remove(this.shard);
        }

        Shard.State saveState() {
            return this.fm.saveState(this.shard);
        }

        void setPrimary(boolean value) {
            this.isPrimary = value;
            if (this.isReallyResumed) {
                if (this.isPrimary) {
                    this.lifecycleRegistry.setCurrentState(Lifecycle.State.RESUMED);
                } else {
                    this.lifecycleRegistry.setCurrentState(Lifecycle.State.STARTED);
                }
            }
        }

        @NonNull
        public Lifecycle getLifecycle() {
            return this.lifecycleRegistry;
        }

        @NonNull
        public ViewModelStore getViewModelStore() {
            return this.parentOwner.getViewModelStore();
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            switch (event) {
                case ON_RESUME: {
                    this.isReallyResumed = true;
                    break;
                }
                case ON_PAUSE: {
                    this.isReallyResumed = false;
                }
            }
            if (this.isPrimary || event != Lifecycle.Event.ON_PAUSE && event != Lifecycle.Event.ON_RESUME) {
                this.lifecycleRegistry.handleLifecycleEvent(event);
            }
        }

        @NonNull
        public SavedStateRegistry getSavedStateRegistry() {
            return this.parentOwner.getSavedStateRegistry();
        }

        @NonNull
        public Context getContext() {
            return this.context;
        }

        @NonNull
        public Shard.Factory getShardFactory() {
            return this.parentOwner.getShardFactory();
        }

        @NonNull
        public ActivityCallbacks getActivityCallbacks() {
            return this.parentOwner.getActivityCallbacks();
        }

        @NonNull
        public ComponentCallbacks getComponentCallbacks() {
            return this.parentOwner.getComponentCallbacks();
        }
    }
}

