/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.PrintStream;
import java.time.LocalDateTime;
import me.tongfei.progressbar.ProgressBarStyle;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.ProgressThread;

public class ProgressBar {
    private ProgressBarStyle style;
    private ProgressState progress;
    private ProgressThread target;
    private Thread thread;

    public ProgressBar(String task, long initialMax) {
        this(task, initialMax, 1000, System.err, ProgressBarStyle.UNICODE_BLOCK);
    }

    public ProgressBar(String task, long initialMax, ProgressBarStyle style) {
        this(task, initialMax, 1000, System.err, style);
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis) {
        this(task, initialMax, updateIntervalMillis, System.err, ProgressBarStyle.UNICODE_BLOCK);
    }

    public ProgressBar(String task, long initialMax, int updateIntervalMillis, PrintStream os, ProgressBarStyle style) {
        this.progress = new ProgressState(task, initialMax);
        this.target = new ProgressThread(this.progress, style, updateIntervalMillis, os);
        this.thread = new Thread(this.target);
    }

    public ProgressBar start() {
        this.progress.startTime = LocalDateTime.now();
        this.thread.start();
        return this;
    }

    public ProgressBar stepBy(long n) {
        this.progress.stepBy(n);
        return this;
    }

    public ProgressBar stepTo(long n) {
        this.progress.stepTo(n);
        return this;
    }

    public ProgressBar step() {
        this.progress.stepBy(1L);
        return this;
    }

    public ProgressBar maxHint(long n) {
        this.progress.maxHint(n);
        return this;
    }

    public ProgressBar stop() {
        this.target.kill();
        try {
            this.thread.join();
            this.target.consoleStream.print("\n");
            this.target.consoleStream.flush();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this;
    }

    public ProgressBar setExtraMessage(String msg) {
        this.progress.setExtraMessage(msg);
        return this;
    }

    public long getCurrent() {
        return this.progress.getCurrent();
    }

    public long getMax() {
        return this.progress.getMax();
    }

    public String getTask() {
        return this.progress.getTask();
    }

    public String getExtraMessage() {
        return this.progress.getExtraMessage();
    }
}

