/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.time.LocalDateTime;

class ProgressState {
    String task;
    long current = 0L;
    long max = 0L;
    LocalDateTime startTime = null;
    String extraMessage = "";

    ProgressState(String task, long initialMax) {
        this.task = task;
        this.max = initialMax;
    }

    synchronized void maxHint(long n) {
        this.max = n;
    }

    synchronized void stepBy(long n) {
        this.current += n;
        if (this.current > this.max) {
            this.max = this.current;
        }
    }

    synchronized void stepTo(long n) {
        this.current = n;
        if (this.current > this.max) {
            this.max = this.current;
        }
    }

    synchronized void setExtraMessage(String msg) {
        this.extraMessage = msg;
    }

    String getTask() {
        return this.task;
    }

    synchronized String getExtraMessage() {
        return this.extraMessage;
    }

    synchronized long getCurrent() {
        return this.current;
    }

    synchronized long getMax() {
        return this.max;
    }
}

