/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.PrintStream;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarStyle;

public class ProgressBarBuilder {
    private String task = "";
    private long initialMax = 0L;
    private ProgressBarStyle style = ProgressBarStyle.COLORFUL_UNICODE_BLOCK;
    private int updateIntervalMillis = 1000;
    private PrintStream stream = System.err;
    private String unitName = "";
    private long unitSize = 1L;
    private boolean showSpeed = false;

    public ProgressBarBuilder setTaskName(String task) {
        this.task = task;
        return this;
    }

    public ProgressBarBuilder setInitialMax(long initialMax) {
        this.initialMax = initialMax;
        return this;
    }

    public ProgressBarBuilder setStyle(ProgressBarStyle style) {
        this.style = style;
        return this;
    }

    public ProgressBarBuilder setUpdateIntervalMillis(int updateIntervalMillis) {
        this.updateIntervalMillis = updateIntervalMillis;
        return this;
    }

    public ProgressBarBuilder setPrintStream(PrintStream stream) {
        this.stream = stream;
        return this;
    }

    public ProgressBarBuilder setUnit(String unitName, long unitSize) {
        this.unitName = unitName;
        this.unitSize = unitSize;
        return this;
    }

    public ProgressBarBuilder showSpeed() {
        this.showSpeed = true;
        return this;
    }

    public ProgressBar build() {
        return new ProgressBar(this.task, this.initialMax, this.updateIntervalMillis, this.stream, this.style, this.unitName, this.unitSize, this.showSpeed);
    }
}

