/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.text.DecimalFormat;
import me.tongfei.progressbar.ConsoleProgressBarConsumer;
import me.tongfei.progressbar.DefaultProgressBarRenderer;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarConsumer;
import me.tongfei.progressbar.ProgressBarStyle;

public class ProgressBarBuilder {
    private String task = "";
    private long initialMax = 0L;
    private int updateIntervalMillis = 1000;
    private ProgressBarStyle style = ProgressBarStyle.COLORFUL_UNICODE_BLOCK;
    private ProgressBarConsumer consumer = null;
    private String unitName = "";
    private long unitSize = 1L;
    private boolean showSpeed = false;
    private DecimalFormat speedFormat;

    public ProgressBarBuilder setTaskName(String task) {
        this.task = task;
        return this;
    }

    public ProgressBarBuilder setInitialMax(long initialMax) {
        this.initialMax = initialMax;
        return this;
    }

    public ProgressBarBuilder setStyle(ProgressBarStyle style) {
        this.style = style;
        return this;
    }

    public ProgressBarBuilder setUpdateIntervalMillis(int updateIntervalMillis) {
        this.updateIntervalMillis = updateIntervalMillis;
        return this;
    }

    public ProgressBarBuilder setConsumer(ProgressBarConsumer consumer) {
        this.consumer = consumer;
        return this;
    }

    public ProgressBarBuilder setUnit(String unitName, long unitSize) {
        this.unitName = unitName;
        this.unitSize = unitSize;
        return this;
    }

    public ProgressBarBuilder showSpeed() {
        return this.showSpeed(new DecimalFormat("#.0"));
    }

    public ProgressBarBuilder showSpeed(DecimalFormat speedFormat) {
        this.showSpeed = true;
        this.speedFormat = speedFormat;
        return this;
    }

    public ProgressBar build() {
        if (this.consumer == null) {
            this.consumer = new ConsoleProgressBarConsumer();
        }
        return new ProgressBar(this.task, this.initialMax, this.updateIntervalMillis, new DefaultProgressBarRenderer(this.style, this.unitName, this.unitSize, this.showSpeed, this.speedFormat), this.consumer);
    }
}

