/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

class Util {
    private static int defaultTerminalWidth = 80;

    Util() {
    }

    static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        char[] s = new char[n];
        for (int i = 0; i < n; ++i) {
            s[i] = c;
        }
        return new String(s);
    }

    static String formatDuration(Duration d) {
        long s = d.getSeconds();
        return String.format("%d:%02d:%02d", s / 3600L, s % 3600L / 60L, s % 60L);
    }

    static long getInputStreamSize(InputStream is) {
        try {
            if (is instanceof FileInputStream) {
                return ((FileInputStream)is).getChannel().size();
            }
        }
        catch (IOException e) {
            return -1L;
        }
        return -1L;
    }

    static Terminal getTerminal() {
        Terminal terminal = null;
        try {
            terminal = TerminalBuilder.builder().dumb(true).build();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return terminal;
    }

    static int getTerminalWidth(Terminal terminal) {
        if (terminal != null && terminal.getWidth() >= 10) {
            return terminal.getWidth();
        }
        return defaultTerminalWidth;
    }

    static int getTerminalWidth() {
        Terminal terminal = Util.getTerminal();
        int width = Util.getTerminalWidth(terminal);
        try {
            if (terminal != null) {
                terminal.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return width;
    }
}

