/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.clirr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.DiffListenerAdapter;

public class BufferedListener
extends DiffListenerAdapter {
    public static final Pattern METHOD_PATTERN = Pattern.compile("((public|private|protected|static|final|native|synchronized|abstract)\\s)*(.+\\s)?([\\$_\\w]+)\\((.*)\\)");
    private final Map<String, List<ApiDifference>> differences;
    private final List<Integer> ignoredDifferenceTypes;
    private final List<String> ignoredPackages;
    private final List<String> ignoredClasses;
    private final Map<String, List<String>> ignoredMembers;

    public BufferedListener(List<Integer> ignoredDifferenceTypes, List<String> ignoredPackages, List<String> ignoredClasses, Map<String, List<String>> ignoredMembers) {
        this.ignoredDifferenceTypes = ignoredDifferenceTypes;
        this.ignoredPackages = ignoredPackages;
        this.ignoredClasses = ignoredClasses;
        this.ignoredMembers = ignoredMembers;
        this.differences = new HashMap<String, List<ApiDifference>>();
    }

    public void reportDiff(ApiDifference difference) {
        if (this.ignoredDifferenceTypes.contains(difference.getMessage().getId())) {
            return;
        }
        String className = difference.getAffectedClass();
        String packageName = className.substring(0, className.lastIndexOf(46));
        if (this.ignoredPackages.contains(packageName) || this.ignoredClasses.contains(className)) {
            return;
        }
        String memberName = BufferedListener.extractMemberName(difference);
        if (memberName != null && this.ignoredMembers.containsKey(className) && this.ignoredMembers.get(className).contains(memberName)) {
            return;
        }
        if (!this.differences.containsKey(className)) {
            this.differences.put(className, new ArrayList());
        }
        this.differences.get(className).add(difference);
    }

    private static String extractSimpleName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static String extractMemberName(ApiDifference difference) {
        if (difference.getAffectedMethod() != null) {
            StringBuilder sb = new StringBuilder();
            Matcher matcher = METHOD_PATTERN.matcher(difference.getAffectedMethod());
            if (matcher.matches()) {
                String stripped = matcher.group(5).replaceAll("\\s+", "");
                if (matcher.group(3) != null) {
                    sb.append(matcher.group(4));
                } else {
                    sb.append(BufferedListener.extractSimpleName(difference.getAffectedClass()));
                }
                sb.append("(").append(stripped).append(")");
                return sb.toString();
            }
            return null;
        }
        if (difference.getAffectedField() != null) {
            return difference.getAffectedField();
        }
        return null;
    }

    public Map<String, List<ApiDifference>> getDifferences() {
        return this.differences;
    }
}

