/*
 * Decompiled with CFR 0.152.
 */
package me.vilsol.menuengine.engine;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import me.vilsol.menuengine.MenuEngine;
import me.vilsol.menuengine.engine.BonusItem;
import me.vilsol.menuengine.engine.DynamicMenuModel;
import me.vilsol.menuengine.engine.Menu;
import me.vilsol.menuengine.engine.MenuItem;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DynamicMenu
extends Menu {
    private HashMap<Integer, MenuItem> dynamicItems = new HashMap();
    private boolean clearOnClose = true;
    private DynamicMenuModel parent;
    private Player owner;

    public DynamicMenu(int size, DynamicMenuModel parent, Player owner) {
        super(parent.getSize(owner).getSize(), null, null);
        this.parent = parent;
        this.owner = owner;
    }

    public DynamicMenuModel getDynamicParent() {
        return this.parent;
    }

    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void regenerateInventory() {
        this.size = this.parent == null ? this.size : this.parent.getSize(this.owner).getSize();
        this.inventory = this.name == null ? Bukkit.createInventory(null, (int)this.size) : Bukkit.createInventory(null, (int)this.size, (String)this.name);
    }

    @Override
    public void showToPlayer(Player plr) {
        this.regenerateInventory();
        this.parent.addItems(this, plr);
        for (Map.Entry item : this.items.entrySet()) {
            this.inventory.setItem(((Integer)item.getKey()).intValue(), ((MenuItem)item.getValue()).getItem());
        }
        plr.openInventory(this.inventory);
        DynamicMenuModel.setLastMenu(plr, this.parent.getClass());
    }

    public void addItemDynamic(Class<? extends MenuItem> itemClass, int slot) {
        if (!MenuItem.items.containsKey(itemClass)) {
            return;
        }
        MenuItem item = MenuItem.items.get(itemClass);
        this.inventory.setItem(slot, item.getItem());
        this.dynamicItems.put(slot, item);
    }

    public void addItemDynamic(MenuItem item, int slot) {
        this.inventory.setItem(slot, item.getItem());
        this.dynamicItems.put(slot, item);
    }

    public <T> void addItemDynamic(Class<? extends BonusItem<?>> itemClass, int slot, T bonus) {
        if (!MenuItem.items.containsKey(itemClass)) {
            return;
        }
        MenuItem item = MenuItem.items.get(itemClass);
        if (bonus != null) {
            try {
                item = (MenuItem)itemClass.getConstructors()[0].newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (!(item instanceof BonusItem)) {
                return;
            }
            ((BonusItem)item).setBonusData(bonus);
        }
        this.inventory.setItem(slot, item.getItem());
        this.dynamicItems.put(slot, item);
    }

    public void placeItem(final int slot, final ItemStack item) {
        final DynamicMenu thisMenu = this;
        new BukkitRunnable(){

            public void run() {
                DynamicMenu.this.parent.onPlaceItem(thisMenu, item, slot);
            }
        }.runTaskLater((Plugin)MenuEngine.getPlugin(), 1L);
        this.delayedRefresh();
    }

    public void removePlaced(final int slot, final ItemStack item) {
        final DynamicMenu thisMenu = this;
        new BukkitRunnable(){

            public void run() {
                DynamicMenu.this.parent.onPickupItem(thisMenu, item, slot);
            }
        }.runTaskLater((Plugin)MenuEngine.getPlugin(), 1L);
        this.delayedRefresh();
    }

    public void delayedRefresh() {
        new BukkitRunnable(){

            public void run() {
                if (DynamicMenu.this.inventory.getViewers() != null && DynamicMenu.this.inventory.getViewers().size() > 0) {
                    ((Player)DynamicMenu.this.inventory.getViewers().get(0)).updateInventory();
                }
            }
        }.runTaskLater((Plugin)MenuEngine.getPlugin(), 2L);
    }

    public HashMap<Integer, MenuItem> getDynamicItems() {
        return this.dynamicItems;
    }

    public boolean isClearOnClose() {
        return this.clearOnClose;
    }

    public void setClearOnClose(boolean clearOnClose) {
        this.clearOnClose = clearOnClose;
    }
}

