/*
 * Decompiled with CFR 0.152.
 */
package me.vilsol.menuengine.engine;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import me.vilsol.menuengine.MenuEngine;
import me.vilsol.menuengine.engine.DynamicMenu;
import me.vilsol.menuengine.enums.InventorySize;
import me.vilsol.menuengine.utils.CallbackResult;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class DynamicMenuModel {
    private static HashMap<Class<? extends DynamicMenuModel>, DynamicMenuModel> menus = new HashMap();
    private static HashMap<Player, Class<? extends DynamicMenuModel>> last_menu = new HashMap();
    private static HashMap<Player, DynamicMenu> playerMenus = new HashMap();
    private static HashMap<Class<? extends DynamicMenuModel>, Class<? extends DynamicMenu>> menu_workers = new HashMap();

    public DynamicMenuModel() {
        menus.put(this.getClass(), this);
        menu_workers.put(this.getClass(), DynamicMenu.class);
    }

    public DynamicMenuModel(Class<? extends DynamicMenu> menu) {
        menus.put(this.getClass(), this);
        menu_workers.put(this.getClass(), menu);
    }

    public abstract void addItems(DynamicMenu var1, Player var2);

    public abstract InventorySize getSize(Player var1);

    public abstract void canPlaceItem(DynamicMenu var1, Player var2, int var3, ItemStack var4, CallbackResult var5, ClickType var6);

    public abstract void canPickupItem(DynamicMenu var1, Player var2, int var3, ItemStack var4, CallbackResult var5, ClickType var6);

    public abstract void onPickupItem(DynamicMenu var1, ItemStack var2, int var3);

    public abstract void onPlaceItem(DynamicMenu var1, ItemStack var2, int var3);

    public static DynamicMenu createMenu(Player plr, Class<? extends DynamicMenuModel> model) {
        Class<? extends DynamicMenu> worker = menu_workers.get(model);
        try {
            DynamicMenu menu = (DynamicMenu)worker.getConstructors()[0].newInstance(menus.get(model).getSize(plr).getSize(), menus.get(model), plr);
            playerMenus.put(plr, menu);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            System.err.println("Wrong Constructor For " + worker.toString() + ", Using default!");
            playerMenus.put(plr, new DynamicMenu(menus.get(model).getSize(plr).getSize(), menus.get(model), plr));
        }
        return playerMenus.get(plr);
    }

    public static DynamicMenu getPlayerMenu(Player plr) {
        if (playerMenus.containsKey(plr)) {
            return playerMenus.get(plr);
        }
        return null;
    }

    public static DynamicMenu getMenu(Player plr) {
        return playerMenus.get(plr);
    }

    public static Class<? extends DynamicMenuModel> getLastMenu(Player plr) {
        return last_menu.get(plr);
    }

    public static void setLastMenu(Player plr, Class<? extends DynamicMenuModel> model) {
        last_menu.put(plr, model);
    }

    public static void openLastMenu(Player plr) {
        if (last_menu.containsKey(plr)) {
            if (playerMenus.containsKey(plr)) {
                playerMenus.get(plr).showToPlayer(plr);
            } else {
                DynamicMenuModel.createMenu(plr, last_menu.get(plr)).showToPlayer(plr);
            }
        }
    }

    public static void cleanInventories(final Player plr, Inventory inventory) {
        new BukkitRunnable(){

            public void run() {
                if (!playerMenus.containsKey(plr)) {
                    return;
                }
                if (((DynamicMenu)playerMenus.get(plr)).getInventory().getViewers().size() > 0) {
                    return;
                }
                if (((DynamicMenu)playerMenus.get(plr)).isClearOnClose()) {
                    playerMenus.remove(plr);
                }
            }
        }.runTaskLater((Plugin)MenuEngine.getPlugin(), 1L);
    }
}

