/*
 * Decompiled with CFR 0.152.
 */
package me.vilsol.menuengine.engine;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import me.vilsol.menuengine.engine.BonusItem;
import me.vilsol.menuengine.engine.MenuItem;
import me.vilsol.menuengine.engine.MenuModel;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Menu {
    protected Inventory inventory;
    protected HashMap<Integer, MenuItem> items = new HashMap();
    protected long lastClick = 0L;
    protected int size;
    protected String name;
    protected MenuModel parent;

    public Menu(int size, String name, MenuModel parent) {
        this.size = size;
        this.name = name;
        this.parent = parent;
        this.regenerateInventory();
    }

    public void regenerateInventory() {
        this.inventory = this.name == null ? Bukkit.createInventory(null, (int)this.size) : Bukkit.createInventory(null, (int)this.size, (String)this.name);
    }

    public HashMap<Integer, MenuItem> getItems() {
        return this.items;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public long getLastClick() {
        return this.lastClick;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public MenuModel getParent() {
        return this.parent;
    }

    public void setName(String name) {
        Inventory newInv = Bukkit.createInventory(null, (int)this.size, (String)name);
        newInv.setContents(this.inventory.getContents());
        this.inventory = newInv;
    }

    public boolean isOurItem(ItemStack item) {
        for (MenuItem i : this.items.values()) {
            if (!i.getItem().equals((Object)item)) continue;
            return true;
        }
        return false;
    }

    public Inventory isThisInventory(Inventory i) {
        if (i.getName().equals(this.inventory.getName())) {
            return this.inventory;
        }
        return null;
    }

    public void showToPlayer(Player plr) {
        plr.openInventory(this.inventory);
        MenuModel.setLastMenu(plr, this.parent.getClass());
    }

    public void addItem(Class<? extends MenuItem> itemClass, int slot) {
        this.addItem(itemClass, slot, null);
    }

    public <T> void addItem(Class<? extends MenuItem> itemClass, int slot, T bonus) {
        if (!MenuItem.items.containsKey(itemClass)) {
            return;
        }
        MenuItem item = MenuItem.items.get(itemClass);
        if (bonus != null) {
            try {
                item = (MenuItem)itemClass.getConstructors()[0].newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (!(item instanceof BonusItem)) {
                return;
            }
            ((BonusItem)item).setBonusData(bonus);
        }
        this.inventory.setItem(slot, item.getItem());
        this.items.put(slot, item);
    }
}

