/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.repository.provider.crud;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import me.wuwenbin.modules.jpa.ancestor.AncestorDao;
import me.wuwenbin.modules.repository.provider.crud.ICrudProvider;
import me.wuwenbin.modules.sql.SQLGen;
import me.wuwenbin.modules.sql.annotation.GeneralType;
import me.wuwenbin.modules.sql.annotation.SQLColumn;
import me.wuwenbin.modules.sql.annotation.SQLPk;
import me.wuwenbin.modules.sql.annotation.SQLTable;
import me.wuwenbin.modules.sql.annotation.support.PkGenType;
import me.wuwenbin.modules.sql.exception.PkFieldNotFoundException;
import me.wuwenbin.modules.sql.factory.SQLBeanBuilder;
import me.wuwenbin.modules.sql.factory.SQLTextBuilder;
import me.wuwenbin.modules.sql.util.SQLDefineUtils;

public abstract class AbstractProvider<T>
implements ICrudProvider {
    private Class<T> clazz;
    private Method method;
    private AncestorDao jdbcTemplate;
    protected SQLBeanBuilder sbb;
    protected SQLTextBuilder stb;
    protected String tableName;
    protected boolean isPkInsert;
    protected String pkFiledName;
    protected String pkDbName;

    public AbstractProvider(Method method, AncestorDao jdbcTemplate, Class<T> clazz) {
        this.method = method;
        this.clazz = clazz;
        this.jdbcTemplate = jdbcTemplate;
        this.init();
    }

    protected Class<T> getClazz() {
        return this.clazz;
    }

    protected AncestorDao getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected Method getMethod() {
        return this.method;
    }

    private void init() {
        SQLTable sqlTable;
        try {
            sqlTable = this.getClazz().getAnnotation(SQLTable.class);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("\u672a\u6307\u5b9a@SQLTable", e);
        }
        try {
            Field pk = SQLGen.builder(this.getClazz()).getPkField();
            this.pkFiledName = pk.getName();
            boolean bl = this.isPkInsert = pk.isAnnotationPresent(GeneralType.class) && pk.getAnnotation(GeneralType.class).value().equals((Object)PkGenType.DEFINITION);
            this.pkDbName = pk.isAnnotationPresent(SQLColumn.class) ? SQLDefineUtils.java2SQL((String)pk.getAnnotation(SQLColumn.class).value(), (String)this.pkFiledName) : SQLDefineUtils.java2SQL((String)pk.getAnnotation(SQLPk.class).value(), (String)this.pkFiledName);
        }
        catch (PkFieldNotFoundException e) {
            this.pkFiledName = "";
            this.isPkInsert = false;
            this.pkDbName = "";
        }
        this.tableName = SQLDefineUtils.java2SQL((String)sqlTable.value(), (String)this.getClazz().getSimpleName());
        this.sbb = SQLGen.builder(this.getClazz());
        this.stb = SQLGen.builder();
    }
}

