/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.repository.provider.find.param;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.wuwenbin.modules.pagination.sort.Sorting;
import me.wuwenbin.modules.pagination.sort.direction.Direction;
import me.wuwenbin.modules.repository.provider.find.support.Condition;
import me.wuwenbin.modules.repository.provider.find.support.FiledValue;

public class SelectQuery {
    private List<String> selectTargets;
    private List<Condition> conditions;
    private List<Sorting> sorts;

    private SelectQuery(List<String> selectTargets, List<Condition> conditions, List<Sorting> sorts) {
        this.selectTargets = selectTargets;
        this.conditions = conditions;
        this.sorts = sorts;
    }

    public List<String> getSelectTargets() {
        return this.selectTargets;
    }

    public void setSelectTargets(List<String> selectTargets) {
        this.selectTargets = selectTargets;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public List<Sorting> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<Sorting> sorts) {
        this.sorts = sorts;
    }

    public static SelectQuery build(List<String> selectTargets, List<Condition> conditions, List<Sorting> sorts) {
        return new SelectQuery(selectTargets, conditions, sorts);
    }

    public static SelectQuery build(List<Condition> conditions) {
        return SelectQuery.build(null, conditions, null);
    }

    public static SelectQuery build(List<String> selectTargets, List<Condition> conditions) {
        return SelectQuery.build(selectTargets, conditions, null);
    }

    public static SelectQuery build(FiledValue ... filedValues) {
        return SelectQuery.build(Condition.buildList(filedValues));
    }

    public static SelectQuery build(Condition ... conditions) {
        return SelectQuery.build(Condition.buildList(conditions));
    }

    public static SelectQuery build(List<String> selectTargets, Condition ... conditions) {
        return SelectQuery.build(selectTargets, Arrays.asList(conditions));
    }

    public String getWhereSqlPart() {
        List<Condition> conditions = this.getConditions();
        String sql = " where 1=1";
        for (Condition condition : conditions) {
            sql = sql.concat(" ").concat(condition.getPreJoin().name()).concat(" ").concat(condition.getConstraint().getPart(condition.getField(), condition.getField()));
        }
        return sql;
    }

    public Map<String, Object> getParamMap() {
        List<Condition> conditions = this.getConditions();
        if (conditions != null) {
            HashMap<String, Object> param = new HashMap<String, Object>(conditions.size());
            for (Condition condition : conditions) {
                param.put(condition.getField(), condition.getValue());
            }
            return param;
        }
        return Collections.emptyMap();
    }

    public SelectQuery sort(String sortName, Direction direction) {
        Sorting sorting = new Sorting();
        sorting.setSortName(sortName);
        sorting.setSortDirection(direction);
        this.setSorts(Collections.singletonList(sorting));
        return this;
    }

    public SelectQuery sortAsc(String sortName) {
        Sorting sort = Sorting.asc((String)sortName);
        this.setSorts(Collections.singletonList(sort));
        return this;
    }

    public SelectQuery sortDesc(String sortName) {
        Sorting sort = Sorting.desc((String)sortName);
        this.setSorts(Collections.singletonList(sort));
        return this;
    }

    public SelectQuery sort(Sorting ... sorts) {
        this.setSorts(Arrays.asList(sorts));
        return this;
    }
}

