/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.repository.provider.find.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.wuwenbin.modules.repository.provider.find.support.Constraint;
import me.wuwenbin.modules.repository.provider.find.support.FiledValue;
import me.wuwenbin.modules.repository.provider.find.support.PreJoin;

public class Condition {
    private PreJoin preJoin;
    private String field;
    private Constraint constraint;
    private Object value;

    private Condition(PreJoin preJoin, String field, Constraint constraint, Object value) {
        this.preJoin = preJoin;
        this.field = field;
        this.value = value;
        this.constraint = constraint;
    }

    public PreJoin getPreJoin() {
        return this.preJoin;
    }

    public void setPreJoin(PreJoin preJoin) {
        this.preJoin = preJoin;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public static Condition build(PreJoin preJoin, String field, Object value, Constraint constraint) {
        return new Condition(preJoin, field, constraint, value);
    }

    public static Condition build(String field, Object value) {
        return new Condition(PreJoin.AND, field, Constraint.Equal, value);
    }

    public static Condition build(String field, Constraint constraint, Object value) {
        return new Condition(PreJoin.AND, field, constraint, value);
    }

    public static List<Condition> buildList(FiledValue ... filedValues) {
        ArrayList<Condition> conditions = new ArrayList<Condition>(filedValues.length);
        for (FiledValue filedValue : filedValues) {
            Condition condition = Condition.build(filedValue.getField(), filedValue.getValue());
            conditions.add(condition);
        }
        return conditions;
    }

    public static List<Condition> buildList(Condition ... conditions) {
        ArrayList<Condition> conditionList = new ArrayList<Condition>(conditions.length);
        conditionList.addAll(Arrays.asList(conditions));
        return conditionList;
    }
}

