/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.repository.provider.find.support;

import org.springframework.util.StringUtils;

public enum Constraint {
    Equal("="),
    Eq("="),
    NotEqual("<>"),
    Ne("<>"),
    Between,
    LessThan("<"),
    Lt("<"),
    LessThanEqual("<="),
    Lte("<="),
    GreaterThan(">"),
    Gt(">"),
    GreaterThanEqual(">="),
    Gte(">="),
    Like("like"),
    NotLike("not like"),
    In("in"),
    NotIn("not in"),
    Not("not"),
    IsNull,
    IsNotNull;

    private String constraint;

    private Constraint() {
    }

    private Constraint(String constraint) {
        this.constraint = constraint;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public boolean keyword() {
        return !StringUtils.isEmpty((Object)this.getConstraint());
    }

    public String getPart(String field) {
        String text = "";
        text = this.getString(field, field, text);
        return text;
    }

    public String getPart(String column, String field) {
        String text = "";
        text = this.getString(column, field, text);
        return text;
    }

    private String getString(String column, String field, String text) {
        if (this.keyword()) {
            text = column.concat(" ").concat(this.constraint).concat(" :").concat(field);
        } else if (this.equals((Object)Between)) {
            text = column.concat(" ").concat("between :prefix").concat(field).concat(" and :suffix").concat(field);
        } else if (this.equals((Object)IsNull)) {
            text = column.concat(" ").concat("is null");
        } else if (this.equals((Object)IsNotNull)) {
            text = column.concat(" ").concat("is not null");
        }
        return text;
    }

    public Constraint getFromName(String name) {
        if (StringUtils.isEmpty((Object)name) || name.equals(Equal.toString())) {
            return Equal;
        }
        if (name.equals(Eq.toString())) {
            return Eq;
        }
        if (name.equals(NotEqual.toString())) {
            return NotEqual;
        }
        if (name.equals(Ne.toString())) {
            return Ne;
        }
        if (name.equals(Between.toString())) {
            return Between;
        }
        if (name.equals(LessThan.toString())) {
            return LessThan;
        }
        if (name.equals(Lt.toString())) {
            return Lt;
        }
        if (name.equals(LessThanEqual.toString())) {
            return LessThanEqual;
        }
        if (name.equals(Lte.toString())) {
            return Lte;
        }
        if (name.equals(GreaterThan.toString())) {
            return GreaterThan;
        }
        if (name.equals(Gt.toString())) {
            return Gt;
        }
        if (name.equals(GreaterThanEqual.toString())) {
            return GreaterThanEqual;
        }
        if (name.equals(Gte.toString())) {
            return Gte;
        }
        if (name.equals(Like.toString())) {
            return Like;
        }
        if (name.equals(NotLike.toString())) {
            return NotLike;
        }
        if (name.equals(In.toString())) {
            return In;
        }
        if (name.equals(NotIn.toString())) {
            return NotIn;
        }
        if (name.equals(Not.toString())) {
            return Not;
        }
        if (name.equals(IsNull.toString())) {
            return IsNull;
        }
        if (name.equals(IsNotNull.toString())) {
            return IsNotNull;
        }
        return Equal;
    }

    public static Constraint getFromEndsWith(String filedPart) {
        if (filedPart.endsWith(Equal.toString())) {
            return Equal;
        }
        if (filedPart.endsWith(Eq.toString())) {
            return Eq;
        }
        if (filedPart.endsWith(NotEqual.toString())) {
            return NotEqual;
        }
        if (filedPart.endsWith(Ne.toString())) {
            return Ne;
        }
        if (filedPart.endsWith(Between.toString())) {
            return Between;
        }
        if (filedPart.endsWith(LessThan.toString())) {
            return LessThan;
        }
        if (filedPart.endsWith(Lt.toString())) {
            return Lt;
        }
        if (filedPart.endsWith(LessThanEqual.toString())) {
            return LessThanEqual;
        }
        if (filedPart.endsWith(Lte.toString())) {
            return Lte;
        }
        if (filedPart.endsWith(GreaterThan.toString())) {
            return GreaterThan;
        }
        if (filedPart.endsWith(Gt.toString())) {
            return Gt;
        }
        if (filedPart.endsWith(GreaterThanEqual.toString())) {
            return GreaterThanEqual;
        }
        if (filedPart.endsWith(Gte.toString())) {
            return Gte;
        }
        if (filedPart.endsWith(Like.toString())) {
            return Like;
        }
        if (filedPart.endsWith(NotLike.toString())) {
            return NotLike;
        }
        if (filedPart.endsWith(In.toString())) {
            return In;
        }
        if (filedPart.endsWith(NotIn.toString())) {
            return NotIn;
        }
        if (filedPart.endsWith(Not.toString())) {
            return Not;
        }
        if (filedPart.endsWith(IsNull.toString())) {
            return IsNull;
        }
        if (filedPart.endsWith(IsNotNull.toString())) {
            return IsNotNull;
        }
        return Equal;
    }
}

