/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.repository.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import me.wuwenbin.modules.jpa.ancestor.AncestorDao;
import me.wuwenbin.modules.jpa.factory.DaoFactory;
import me.wuwenbin.modules.repository.provider.crud.ICrudProvider;
import me.wuwenbin.modules.repository.util.BeanUtils;
import me.wuwenbin.modules.repository.util.ExceptionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class RepositoryProxyFactory<T>
implements InvocationHandler,
InitializingBean,
ApplicationContextAware {
    private AncestorDao jdbcTemplate;
    private ApplicationContext applicationContext;

    public T newInstance(Class<T> targetClass) {
        return (T)Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (Throwable t) {
                throw ExceptionUtils.unwrapThrowable(t);
            }
        }
        Class currentClass = (Class)((ParameterizedType)((Class)proxy.getClass().getGenericInterfaces()[0]).getGenericInterfaces()[0]).getActualTypeArguments()[0];
        ICrudProvider provider = BeanUtils.getProvider(method, this.jdbcTemplate, currentClass);
        return provider.execute(args);
    }

    public void afterPropertiesSet() {
        DaoFactory daoFactory = (DaoFactory)this.applicationContext.getBean(DaoFactory.class);
        this.jdbcTemplate = daoFactory.dynamicDao;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

