/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.repository.registry;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import me.wuwenbin.modules.repository.annotation.type.Repository;
import me.wuwenbin.modules.repository.proxy.RepositoryProxyFactory;
import me.wuwenbin.modules.utils.lang.clazz.ClassScanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.AnnotationScopeMetadataResolver;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RepositoryRegistry
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryRegistry.class);
    private ScopeMetadataResolver scopeMetadataResolver = new AnnotationScopeMetadataResolver();
    private BeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();
    private RepositoryProxyFactory repositoryProxyFactory = new RepositoryProxyFactory();
    private String scanBasePackage;

    public RepositoryRegistry() {
        this.scanBasePackage = "";
    }

    public RepositoryRegistry(String scanBasePackage) {
        this.scanBasePackage = scanBasePackage;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        int cnt = 0;
        try {
            logger.info("========== \u5f00\u59cb\u626b\u63cf\u542b\u6709 [@Repository] \u7684 Bean ==========");
            Set<Class<?>> repositories = this.scanBootServiceInterfaces();
            logger.info("========== \u626b\u63cf\u7ed3\u675f\uff0c\u4ee5\u4f9b\u626b\u63cf\u5230\u542b\u6709 [@Repository] \u7684 Bean {} \u4e2a ==========", (Object)repositories.size());
            logger.info("========== \u5f00\u59cb\u6ce8\u518c\u626b\u63cf\u5230\u7684 [Repositories] \u81f3 Spring \u5bb9\u5668\u4e2d ==========");
            for (Class<?> repository : repositories) {
                Repository repositoryClass = repository.getAnnotation(Repository.class);
                String beanName = repositoryClass.value();
                String simpleBeanName = StringUtils.isEmpty((Object)beanName) ? repository.getName().substring(0, 1).toLowerCase().concat(repository.getName().substring(1)) : beanName;
                Class<?> clazz = this.repositoryProxyFactory.newInstance(repository).getClass();
                logger.info("-- \u5f00\u59cb\u6ce8\u518c [BeanClass : {} \uff0cBeanName\uff1a{}] --", repository, (Object)simpleBeanName);
                this.registerBean(beanDefinitionRegistry, simpleBeanName, clazz);
                logger.info("-- \u6ce8\u518c [BeanClass : {}] \u7ed3\u675f--", repository);
                ++cnt;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            logger.error("\uff01\uff01\uff01\u626b\u63cfRepository\u7c7b\u5931\u8d25\uff01\uff01\uff01", (Throwable)e);
        }
        logger.info("========== \u6ce8\u518c\u7ed3\u675f\uff0c\u603b\u8ba1\u6ce8\u518c\u6210\u529f\u7684 [Repositories] \u4e2a\u6570\u4e3a {} \u4e2a ==========", (Object)cnt);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    private void registerBean(BeanDefinitionRegistry registry, String name, Class<?> beanClass) {
        AnnotatedGenericBeanDefinition abd = new AnnotatedGenericBeanDefinition(beanClass);
        ScopeMetadata scopeMetadata = this.scopeMetadataResolver.resolveScopeMetadata((BeanDefinition)abd);
        abd.setScope(scopeMetadata.getScopeName());
        String beanName = !StringUtils.isEmpty((Object)name) ? name : this.beanNameGenerator.generateBeanName((BeanDefinition)abd, registry);
        AnnotationConfigUtils.processCommonDefinitionAnnotations((AnnotatedBeanDefinition)abd);
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)abd, beanName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry);
    }

    private Set<Class<?>> scanBootServiceInterfaces() throws IOException, ClassNotFoundException {
        HashSet<Class<Repository>> classSet = new HashSet<Class<Repository>>();
        classSet.add(Repository.class);
        return ClassScanUtils.scan((String)this.scanBasePackage, classSet, null);
    }
}

