/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.repository.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import me.wuwenbin.modules.jpa.ancestor.AncestorDao;
import me.wuwenbin.modules.repository.constant.MethodType;
import me.wuwenbin.modules.repository.exception.MethodExecuteException;
import me.wuwenbin.modules.repository.exception.MethodTypeMismatchException;
import me.wuwenbin.modules.repository.provider.crud.ICrudProvider;
import me.wuwenbin.modules.repository.provider.delete.DeleteProvider;
import me.wuwenbin.modules.repository.provider.find.ReadProvider;
import me.wuwenbin.modules.repository.provider.find.support.Constraint;
import me.wuwenbin.modules.repository.provider.save.CreateProvider;
import me.wuwenbin.modules.repository.provider.select.page.PageProvider;
import me.wuwenbin.modules.repository.provider.select.random.RandProvider;
import me.wuwenbin.modules.repository.provider.update.UpdateProvider;
import me.wuwenbin.modules.sql.annotation.SQLColumn;
import me.wuwenbin.modules.sql.util.SQLBuilderUtils;
import me.wuwenbin.modules.sql.util.SQLDefineUtils;
import org.springframework.util.StringUtils;

public class BeanUtils {
    public static ICrudProvider getProvider(Method method, AncestorDao jdbcTemplate, Class<?> clazz) throws MethodTypeMismatchException {
        String methodName = method.getName();
        if (StringUtils.isEmpty((Object)methodName)) {
            throw new RuntimeException("\u65b9\u6cd5\u540d\u4e3a\u7a7a\uff01\uff1f");
        }
        if (methodName.equalsIgnoreCase(MethodType.PAGE.getName())) {
            return new PageProvider(method, jdbcTemplate, clazz);
        }
        if (methodName.startsWith(MethodType.SAVE.getName())) {
            return new CreateProvider(method, jdbcTemplate, clazz);
        }
        if (methodName.startsWith(MethodType.DELETE.getName())) {
            return new DeleteProvider(method, jdbcTemplate, clazz);
        }
        if (methodName.startsWith(MethodType.COUNT.getName()) || methodName.startsWith(MethodType.FIND.getName())) {
            return new ReadProvider(method, jdbcTemplate, clazz);
        }
        if (methodName.startsWith(MethodType.UPDATE.getName())) {
            return new UpdateProvider(method, jdbcTemplate, clazz);
        }
        if (methodName.startsWith(MethodType.RAND.getName())) {
            return new RandProvider(method, jdbcTemplate, clazz);
        }
        throw new MethodTypeMismatchException();
    }

    public static int[] getRouters(String methodName, int startIndex) throws Exception {
        String routerText = methodName.substring(startIndex);
        routerText = routerText.toLowerCase();
        char[] routerChars = routerText.toCharArray();
        if (routerText.split("").length != routerChars.length) {
            throw new Exception("\u65b9\u6cd5\u547d\u540d\u4e2d\u7684Router\u90e8\u5206\u6709\u8bef\uff0c\u8bf7\u4fee\u6b63\uff01");
        }
        int[] routers = new int[routerChars.length];
        for (int i = 0; i < routerChars.length; ++i) {
            routers[i] = Integer.MIN_VALUE + routerChars[i];
        }
        return routers;
    }

    public static boolean paramTypeMapOrSub(Object param) {
        return param instanceof Map;
    }

    public static boolean paramTypeJavaBeanOrSub(Object param, Class<?> javaBeanClass) {
        return param.getClass().equals(javaBeanClass) || javaBeanClass.isAssignableFrom(param.getClass());
    }

    public static boolean paramTypeCollectionOrSub(Object param) {
        return param instanceof Collection;
    }

    public static boolean paramTypeArray(Object param) {
        return param.getClass().isArray();
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Byte.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(BigDecimal.class) || clazz.equals(BigInteger.class) || clazz.equals(Boolean.class) || clazz.equals(Date.class) || clazz.equals(LocalDate.class) || clazz.equals(LocalDateTime.class) || clazz.isPrimitive();
    }

    public static boolean isPrimitive(Object param) {
        return param instanceof Integer || param instanceof String || param instanceof Double || param instanceof Float || param instanceof Long || param instanceof Boolean || param instanceof Date;
    }

    public static List<Field> getFieldsByRouter(Class clazz, int router) {
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject((Class)clazz);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : fields) {
            int[] nArray;
            if (field.isAnnotationPresent(SQLColumn.class)) {
                nArray = field.getAnnotation(SQLColumn.class).routers();
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = Integer.MIN_VALUE;
            }
            int[] routers = nArray;
            if (!SQLBuilderUtils.fieldRoutersInParamRouters((int[])routers, (int[])new int[]{router})) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    public static void getWherePart(String methodName, String fieldStr, String[] fields, StringBuilder sqlBuilder, boolean colon) throws MethodExecuteException {
        for (int i = 0; i < fields.length; ++i) {
            String temp;
            String fieldPart = fields[i];
            Constraint constraint = Constraint.getFromEndsWith(fieldPart);
            String field = fieldPart.endsWith(constraint.name()) ? fieldPart : fieldPart.concat(constraint.name());
            field = field.substring(0, field.length() - constraint.toString().length());
            String column = SQLDefineUtils.java2SQL((String)"", (String)field);
            if (i == 0) {
                field = field.substring(0, 1).toLowerCase().concat(field.substring(1, field.length()));
                if (colon) {
                    sqlBuilder.append(constraint.getPart(column, field));
                    continue;
                }
                String temp2 = constraint.getPart(column, field);
                sqlBuilder.append(temp2.substring(0, temp2.indexOf(":"))).append(" ?");
                continue;
            }
            String tempAnd = fields[i - 1].concat("And").concat(fieldPart);
            String tempOr = fields[i - 1].concat("Or").concat(fieldPart);
            if (fieldStr.contains(tempAnd)) {
                field = field.substring(0, 1).toLowerCase().concat(field.substring(1, field.length()));
                if (colon) {
                    sqlBuilder.append(" and ").append(constraint.getPart(column, field));
                    continue;
                }
                temp = constraint.getPart(column, field);
                sqlBuilder.append(" and ").append(temp.substring(0, temp.indexOf(":"))).append(" ?");
                continue;
            }
            if (fieldStr.contains(tempOr)) {
                if (colon) {
                    sqlBuilder.append(" or ").append(constraint.getPart(column, field));
                    continue;
                }
                temp = constraint.getPart(column, field);
                sqlBuilder.append(" or ").append(temp.substring(0, temp.indexOf(":"))).append(" ?");
                continue;
            }
            throw new MethodExecuteException("\u65b9\u6cd5:\u300c" + methodName + "\u300d\u547d\u540d\u6709\u8bef\uff0c\u8bf7\u53c2\u8003\u547d\u540d\u89c4\u5219\uff01");
        }
    }
}

