/*
 * Decompiled with CFR 0.152.
 */
package me.xdrop.fuzzywuzzy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.xdrop.fuzzywuzzy.Applicable;
import me.xdrop.fuzzywuzzy.algorithms.Utils;
import me.xdrop.fuzzywuzzy.model.ExtractedResult;

public class Extractor {
    private int cutoff;

    public Extractor() {
        this.cutoff = 0;
    }

    public Extractor(int cutoff) {
        this.cutoff = cutoff;
    }

    public Extractor with(int cutoff) {
        this.setCutoff(cutoff);
        return this;
    }

    public List<ExtractedResult> extractWithoutOrder(String query, Collection<String> choices, Applicable func) {
        ArrayList<ExtractedResult> yields = new ArrayList<ExtractedResult>();
        for (String s : choices) {
            int score = func.apply(query, s);
            if (score < this.cutoff) continue;
            yields.add(new ExtractedResult(s, score));
        }
        return yields;
    }

    public ExtractedResult extractOne(String query, Collection<String> choice, Applicable func) {
        List<ExtractedResult> extracted = this.extractWithoutOrder(query, choice, func);
        return Collections.max(extracted);
    }

    public List<ExtractedResult> extractTop(String query, Collection<String> choices, Applicable func) {
        List<ExtractedResult> best = this.extractWithoutOrder(query, choices, func);
        Collections.sort(best, Collections.reverseOrder());
        return best;
    }

    public List<ExtractedResult> extractTop(String query, Collection<String> choices, Applicable func, int limit) {
        List<ExtractedResult> best = this.extractWithoutOrder(query, choices, func);
        List<ExtractedResult> results = Utils.findTopKHeap(best, limit);
        Collections.reverse(results);
        return results;
    }

    public int getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(int cutoff) {
        this.cutoff = cutoff;
    }
}

