/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.chatapi.wechat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import me.xuxiaoxiao.chatapi.wechat.WeChatTools;
import me.xuxiaoxiao.chatapi.wechat.protocol.BaseRequest;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqBatchGetContact;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqCheckUpload;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqInit;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqOplog;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqRevokeMsg;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqSendMsg;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqStatusNotify;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqSync;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqUpdateChatroom;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqUploadMedia;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqVerifyUser;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspBatchGetContact;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspCheckUpload;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspGetContact;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspInit;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspLogin;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspOplog;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspRevokeMsg;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspSendMsg;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspStatusNotify;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspSync;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspSyncCheck;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspUpdateChatroom;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspUploadMedia;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspVerifyUser;
import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.http.executor.XHttpExecutor;
import me.xuxiaoxiao.xtools.common.http.executor.impl.XHttpExecutorImpl;
import me.xuxiaoxiao.xtools.common.http.executor.impl.XRequest;

final class WeChatApi {
    public static final String CFG_WORKDIR = "me.xuxiaoxiao$chatapi-wechat$workdir";
    public static final String CFG_WORKDIR_DEFAULT = "";
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final String[] HOSTS = new String[]{"wx.qq.com", "wx2.qq.com", "wx8.qq.com", "web.wechat.com", "web2.wechat.com"};
    private static final Pattern REX_LOGIN = Pattern.compile("<error>[\\s\\S]+</error>");
    private final long timeInit = System.currentTimeMillis();
    private final AtomicBoolean firstLogin = new AtomicBoolean(true);
    private final XHttpExecutor httpExecutor = new XHttpExecutorImpl();
    String host;
    String uin;
    String sid;
    String dataTicket;
    File folder = new File(XTools.cfgDef((String)"me.xuxiaoxiao$chatapi-wechat$workdir", (String)""));
    private long time = this.timeInit;
    private int file = 0;
    private String uuid;
    private String skey;
    private String passticket;
    private RspInit.SyncKey synckey;
    private RspInit.SyncKey syncCheckKey;

    WeChatApi() {
    }

    String jslogin() {
        XRequest request = XRequest.GET((String)"https://login.wx.qq.com/jslogin");
        request.query("_", (Object)this.time++);
        request.query("appid", (Object)"wx782c26e4c19acffb");
        request.query("fun", (Object)"new");
        request.query("lang", (Object)"zh_CN");
        request.query("redirect_uri", (Object)"https://wx.qq.com/cgi-bin/mmwebwx-bin/webwxnewloginpage");
        String rspStr = XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string();
        if (XTools.strEmpty((String)rspStr)) {
            throw new IllegalStateException("\u83b7\u53d6\u767b\u5f55\u4e8c\u7ef4\u7801\u51fa\u9519");
        }
        this.uuid = rspStr.substring(rspStr.indexOf(34) + 1, rspStr.lastIndexOf(34));
        return "https://login.weixin.qq.com/qrcode/" + this.uuid;
    }

    RspLogin login() {
        XRequest request = XRequest.GET((String)"https://login.wx.qq.com/cgi-bin/mmwebwx-bin/login");
        request.query("_", (Object)this.time++);
        request.query("loginicon", (Object)true);
        request.query("r", (Object)((int)(System.currentTimeMillis() ^ 0xFFFFFFFFFFFFFFFFL)));
        request.query("tip", (Object)(this.firstLogin.getAndSet(false) ? 1 : 0));
        request.query("uuid", (Object)this.uuid);
        RspLogin rspLogin = new RspLogin(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string());
        if (!XTools.strEmpty((String)rspLogin.redirectUri)) {
            for (String host : HOSTS) {
                if (!rspLogin.redirectUri.contains(host)) continue;
                this.host = host;
                break;
            }
            if (XTools.strEmpty((String)this.host)) {
                throw new IllegalStateException("\u672a\u77e5\u4e3b\u673a");
            }
        }
        return rspLogin;
    }

    void webwxnewloginpage(String url) {
        String rspStr = XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)XRequest.GET((String)url)).string();
        if (!XTools.strEmpty((String)rspStr) && REX_LOGIN.matcher(rspStr).find()) {
            this.uin = rspStr.substring(rspStr.indexOf("<wxuin>") + "<wxuin>".length(), rspStr.indexOf("</wxuin>"));
            this.sid = rspStr.substring(rspStr.indexOf("<wxsid>") + "<wxsid>".length(), rspStr.indexOf("</wxsid>"));
            this.skey = rspStr.substring(rspStr.indexOf("<skey>") + "<skey>".length(), rspStr.indexOf("</skey>"));
            this.passticket = rspStr.substring(rspStr.indexOf("<pass_ticket>") + "<pass_ticket>".length(), rspStr.indexOf("</pass_ticket>"));
        }
    }

    RspInit webwxinit() {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxinit", this.host));
        request.query("r", (Object)((int)(this.timeInit ^ 0xFFFFFFFFFFFFFFFFL)));
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqInit(new BaseRequest(this.uin, this.sid, this.skey)))));
        RspInit rspInit = (RspInit)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspInit.class);
        this.skey = rspInit.SKey;
        this.synckey = rspInit.SyncKey;
        return rspInit;
    }

    RspStatusNotify webwxstatusnotify(String userName, int notifyCode) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxstatusnotify", this.host));
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqStatusNotify(new BaseRequest(this.uin, this.sid, this.skey), notifyCode, userName))));
        return (RspStatusNotify)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspStatusNotify.class);
    }

    RspGetContact webwxgetcontact() {
        XRequest request = XRequest.GET((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxgetcontact", this.host));
        request.query("r", (Object)System.currentTimeMillis());
        request.query("seq", (Object)0);
        request.query("skey", (Object)this.skey);
        request.query("pass_ticket", (Object)this.passticket);
        return (RspGetContact)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspGetContact.class);
    }

    RspBatchGetContact webwxbatchgetcontact(List<ReqBatchGetContact.Contact> contactList) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxbatchgetcontact", this.host));
        request.query("r", (Object)System.currentTimeMillis());
        request.query("type", (Object)"ex");
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqBatchGetContact(new BaseRequest(this.uin, this.sid, this.skey), contactList))));
        return (RspBatchGetContact)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspBatchGetContact.class);
    }

    RspSyncCheck synccheck() {
        XRequest request = XRequest.GET((String)String.format("https://webpush.%s/cgi-bin/mmwebwx-bin/synccheck", this.host));
        request.query("uin", (Object)this.uin);
        request.query("sid", (Object)this.sid);
        request.query("skey", (Object)this.skey);
        request.query("deviceId", (Object)BaseRequest.deviceId());
        request.query("synckey", (Object)(this.syncCheckKey != null ? this.syncCheckKey : this.synckey));
        request.query("r", (Object)System.currentTimeMillis());
        request.query("_", (Object)this.time++);
        return new RspSyncCheck(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string());
    }

    RspSync webwxsync() {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxsync", this.host));
        request.query("sid", (Object)this.sid);
        request.query("skey", (Object)this.skey);
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqSync(new BaseRequest(this.uin, this.sid, this.skey), this.synckey))));
        RspSync rspSync = (RspSync)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspSync.class);
        if (rspSync.SyncKey != null && rspSync.SyncKey.List != null && !rspSync.SyncKey.List.isEmpty()) {
            this.synckey = rspSync.SyncKey;
        }
        if (rspSync.SyncCheckKey != null && rspSync.SyncCheckKey.List != null && !rspSync.SyncCheckKey.List.isEmpty()) {
            this.syncCheckKey = rspSync.SyncCheckKey;
        }
        return rspSync;
    }

    RspSendMsg webwxsendmsg(ReqSendMsg.Msg msg) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxsendmsg", this.host));
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqSendMsg(new BaseRequest(this.uin, this.sid, this.skey), msg))));
        return (RspSendMsg)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspSendMsg.class);
    }

    RspSendMsg webwxsendmsgimg(ReqSendMsg.Msg msg) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxsendmsgimg", this.host));
        request.query("fun", (Object)"async");
        request.query("f", (Object)"json");
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqSendMsg(new BaseRequest(this.uin, this.sid, this.skey), msg))));
        return (RspSendMsg)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspSendMsg.class);
    }

    RspSendMsg webwxsendvideomsg(ReqSendMsg.Msg msg) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxsendvideomsg", this.host));
        request.query("fun", (Object)"async");
        request.query("f", (Object)"json");
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqSendMsg(new BaseRequest(this.uin, this.sid, this.skey), msg))));
        return (RspSendMsg)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspSendMsg.class);
    }

    RspSendMsg webwxsendemoticon(ReqSendMsg.Msg msg) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxsendemoticon", this.host));
        request.query("fun", (Object)"sys");
        request.query("f", (Object)"json");
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqSendMsg(new BaseRequest(this.uin, this.sid, this.skey), msg))));
        return (RspSendMsg)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspSendMsg.class);
    }

    RspSendMsg webwxsendappmsg(ReqSendMsg.Msg msg) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxsendappmsg", this.host));
        request.query("fun", (Object)"async");
        request.query("f", (Object)"json");
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqSendMsg(new BaseRequest(this.uin, this.sid, this.skey), msg))));
        return (RspSendMsg)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspSendMsg.class);
    }

    RspRevokeMsg webwxrevokemsg(long clientMsgId, long serverMsgId, String userName) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxrevokemsg", this.host));
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqRevokeMsg(new BaseRequest(this.uin, this.sid, this.skey), String.valueOf(clientMsgId), String.valueOf(serverMsgId), userName))));
        return (RspRevokeMsg)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspRevokeMsg.class);
    }

    File webwxgetmsgimg(long msgId, String type) {
        XRequest request = XRequest.GET((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxgetmsgimg", this.host));
        request.query("MsgID", (Object)msgId);
        request.query("skey", (Object)this.skey);
        request.query("type", (Object)type);
        request.query("pass_ticket", (Object)this.passticket);
        File imgFile = XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).file(this.folder.getAbsolutePath() + File.separator + String.format("image-%s-%s", String.valueOf(type), msgId));
        try {
            String suffix = WeChatTools.fileSuffix(imgFile);
            if (!XTools.strEmpty((String)suffix)) {
                File file = XTools.fileToFile((File)imgFile, (String)(this.folder.getAbsolutePath() + File.separator + String.format("image-%s-%s.%s", String.valueOf(type), msgId, suffix)));
                imgFile.delete();
                return file;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imgFile;
    }

    File webwxgetvoice(long msgId) {
        XRequest request = XRequest.GET((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxgetvoice", this.host));
        request.query("msgid", (Object)msgId);
        request.query("skey", (Object)this.skey);
        request.query("pass_ticket", (Object)this.passticket);
        return XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).file(this.folder.getAbsolutePath() + File.separator + String.format("voice-%s.mp3", msgId));
    }

    File webwxgetvideo(long msgId) {
        XRequest request = XRequest.GET((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxgetvideo", this.host));
        request.query("msgid", (Object)msgId);
        request.query("skey", (Object)this.skey);
        request.query("pass_ticket", (Object)this.passticket);
        request.header("Range", "bytes=0-");
        return XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).file(this.folder.getAbsolutePath() + File.separator + String.format("video-%d.mp4", msgId));
    }

    File webwxgetmedia(long msgId, String filename, String mediaId, String sender) {
        XRequest request = XRequest.GET((String)String.format("https://file.%s/cgi-bin/mmwebwx-bin/webwxgetmedia", this.host));
        request.query("encryfilename", (Object)filename);
        request.query("fromuser", (Object)this.uin);
        request.query("mediaid", (Object)mediaId);
        request.query("pass_ticket", (Object)this.passticket);
        request.query("sender", (Object)sender);
        request.query("webwx_data_ticket", (Object)this.dataTicket);
        String suffix = filename.lastIndexOf(46) > 0 ? filename.substring(filename.lastIndexOf(46)) : CFG_WORKDIR_DEFAULT;
        return XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).file(this.folder.getAbsolutePath() + File.separator + String.format("media-%d%s", msgId, suffix));
    }

    RspVerifyUser webwxverifyuser(int opCode, String userName, String verifyTicket, String verifyContent) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxverifyuser", this.host));
        request.query("r", (Object)System.currentTimeMillis());
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqVerifyUser(new BaseRequest(this.uin, this.sid, this.skey), opCode, userName, verifyTicket, verifyContent))));
        return (RspVerifyUser)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspVerifyUser.class);
    }

    RspOplog webwxoplog(int cmdId, int op, String userName, String remarkName) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxoplog", this.host));
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqOplog(new BaseRequest(this.uin, this.sid, this.skey), cmdId, op, userName, remarkName))));
        return (RspOplog)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspOplog.class);
    }

    RspUpdateChatroom webwxupdatechartroom(String chatroom, String fun, String name, List<String> memberList) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxupdatechatroom", this.host));
        request.query("fun", (Object)fun);
        request.query("pass_ticket", (Object)this.passticket);
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqUpdateChatroom(new BaseRequest(this.uin, this.sid, this.skey), chatroom, fun, name, XTools.strJoin(memberList, (String)",")))));
        return (RspUpdateChatroom)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspUpdateChatroom.class);
    }

    RspCheckUpload webwxcheckupload(File file, String fromUserName, String toUserName) {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxcheckupload", this.host));
        request.content((XHttpExecutor.Content)new XRequest.StringContent("application/json", GSON.toJson((Object)new ReqCheckUpload(new BaseRequest(this.uin, this.sid, this.skey), file, fromUserName, toUserName))));
        return (RspCheckUpload)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspCheckUpload.class);
    }

    RspUploadMedia webwxuploadmedia(String fromUserName, String toUserName, File file, String aesKey, String signature) throws IOException {
        int fileId = this.file++;
        String fileName = file.getName();
        String fileMime = Files.probeContentType(Paths.get(file.getAbsolutePath(), new String[0]));
        String fileMd5 = XTools.md5((File)file);
        String fileType = WeChatTools.fileType(file);
        long fileLength = file.length();
        long clientMediaId = ReqUploadMedia.clientMediaId();
        String deviceId = BaseRequest.deviceId();
        if (file.length() < 0x100000L) {
            XRequest request = XRequest.POST((String)String.format("https://file.%s/cgi-bin/mmwebwx-bin/webwxuploadmedia", this.host));
            request.query("f", (Object)"json");
            request.content("id", (Object)String.format("WU_FILE_%d", fileId));
            request.content("name", (Object)fileName);
            request.content("type", (Object)fileMime);
            request.content("lastModifiedDate", (Object)new Date(file.lastModified()));
            request.content("size", (Object)fileLength);
            request.content("mediatype", (Object)fileType);
            request.content("uploadmediarequest", (Object)GSON.toJson((Object)new ReqUploadMedia(new BaseRequest(this.uin, this.sid, this.skey, deviceId), clientMediaId, 2, fileLength, 0L, fileLength, fileMd5, aesKey, signature, fromUserName, toUserName)));
            request.content("webwx_data_ticket", (Object)this.dataTicket);
            request.content("pass_ticket", (Object)(XTools.strEmpty((String)this.passticket) ? "undefined" : this.passticket));
            request.content("filename", (Object)file);
            return (RspUploadMedia)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspUploadMedia.class);
        }
        RspUploadMedia rspUploadMedia = null;
        byte[] sliceBuffer = new byte[524288];
        try (BufferedInputStream bfinStream = new BufferedInputStream(new FileInputStream(file));){
            long sliceCount = (long)Math.ceil((double)file.length() / 512.0 / 1024.0);
            for (long sliceIndex = 0L; sliceIndex < sliceCount; ++sliceIndex) {
                int readCount;
                XRequest request = XRequest.POST((String)String.format("https://file.%s/cgi-bin/mmwebwx-bin/webwxuploadmedia", this.host));
                request.query("f", (Object)"json");
                request.content("id", (Object)String.format("WU_FILE_%d", fileId));
                request.content("name", (Object)fileName);
                request.content("type", (Object)fileMime);
                request.content("lastModifiedDate", (Object)new Date(file.lastModified()));
                request.content("size", (Object)fileLength);
                request.content("chunks", (Object)sliceCount);
                request.content("chunk", (Object)sliceIndex);
                request.content("mediatype", (Object)fileType);
                request.content("uploadmediarequest", (Object)GSON.toJson((Object)new ReqUploadMedia(new BaseRequest(this.uin, this.sid, this.skey, deviceId), clientMediaId, 2, fileLength, 0L, fileLength, fileMd5, aesKey, signature, fromUserName, toUserName)));
                request.content("webwx_data_ticket", (Object)this.dataTicket);
                request.content("pass_ticket", (Object)(XTools.strEmpty((String)this.passticket) ? "undefined" : this.passticket));
                WeChatTools.Slice slice = new WeChatTools.Slice("filename", fileName, fileMime, sliceBuffer, 0);
                while ((readCount = bfinStream.read(sliceBuffer, slice.count, sliceBuffer.length - slice.count)) > 0) {
                    slice.count += readCount;
                    if (slice.count < sliceBuffer.length) continue;
                }
                request.content("filename", (Object)slice);
                rspUploadMedia = (RspUploadMedia)GSON.fromJson(XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string(), RspUploadMedia.class);
            }
        }
        return rspUploadMedia;
    }

    void webwxlogout() {
        XRequest request = XRequest.POST((String)String.format("https://%s/cgi-bin/mmwebwx-bin/webwxlogout", this.host));
        request.query("redirect", (Object)1);
        request.query("type", (Object)0);
        request.query("skey", (Object)this.skey);
        request.content("sid", (Object)this.sid);
        request.content("uin", (Object)this.uin);
        XTools.http((XHttpExecutor)this.httpExecutor, (XHttpExecutor.Request)request).string();
    }
}

