/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.chatapi.wechat;

import java.io.File;
import java.io.IOException;
import java.net.HttpCookie;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xuxiaoxiao.chatapi.wechat.WeChatApi;
import me.xuxiaoxiao.chatapi.wechat.WeChatContacts;
import me.xuxiaoxiao.chatapi.wechat.WeChatTools;
import me.xuxiaoxiao.chatapi.wechat.entity.contact.WXContact;
import me.xuxiaoxiao.chatapi.wechat.entity.contact.WXGroup;
import me.xuxiaoxiao.chatapi.wechat.entity.contact.WXUser;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXEmoji;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXFile;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXImage;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXLink;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXLocation;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXMessage;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXMoney;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXNotify;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXRecommend;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXRevoke;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXSystem;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXText;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXUnknown;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXVerify;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXVideo;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXVoice;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqBatchGetContact;
import me.xuxiaoxiao.chatapi.wechat.protocol.ReqSendMsg;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspBatchGetContact;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspCheckUpload;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspGetContact;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspInit;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspLogin;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspSendMsg;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspSync;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspSyncCheck;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspUploadMedia;
import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.http.XHttpTools;
import me.xuxiaoxiao.xtools.common.http.executor.XHttpExecutor;
import me.xuxiaoxiao.xtools.common.http.executor.impl.XRequest;

public final class WeChatClient {
    public static final String CFG_PREFIX = "me.xuxiaoxiao$chatapi-wechat$";
    public static final String LOG_TAG = "chatapi-wechat";
    public static final String LOGIN_TIMEOUT = "\u767b\u9646\u8d85\u65f6";
    public static final String LOGIN_EXCEPTION = "\u767b\u9646\u5f02\u5e38";
    public static final String INIT_EXCEPTION = "\u521d\u59cb\u5316\u5f02\u5e38";
    public static final String LISTEN_EXCEPTION = "\u76d1\u542c\u5f02\u5e38";
    public static final int STATUS_EXCEPTION = -1;
    public static final int STATUS_READY = 0;
    public static final int STATUS_SCAN = 1;
    public static final int STATUS_PERMIT = 2;
    public static final int STATUS_WORKING = 3;
    public static final int STATUS_LOGOUT = 4;
    private static final Pattern REX_GROUPMSG = Pattern.compile("(@[0-9a-zA-Z]+):<br/>([\\s\\S]*)");
    private static final Pattern REX_REVOKE_ID = Pattern.compile("&lt;msgid&gt;(\\d+)&lt;/msgid&gt;");
    private static final Pattern REX_REVOKE_REPLACE = Pattern.compile("&lt;replacemsg&gt;&lt;!\\[CDATA\\[([\\s\\S]*)]]&gt;&lt;/replacemsg&gt;");
    private final WeChatThread wxThread = new WeChatThread();
    private final WeChatContacts wxContacts = new WeChatContacts();
    private final WeChatApi wxAPI = new WeChatApi();
    private volatile WeChatListener wxListener;
    private volatile int status = 0;

    private void handleQRCode(@Nonnull String qrcode) {
        this.status = 1;
        WeChatListener listener = this.wxListener;
        if (listener != null) {
            listener.onQRCode(this, qrcode);
        }
    }

    private void handleAvatar(@Nonnull String base64Avatar) {
        this.status = 2;
        WeChatListener listener = this.wxListener;
        if (listener != null) {
            listener.onAvatar(this, base64Avatar);
        }
    }

    private void handleFailure(@Nonnull String reason) {
        this.status = -1;
        WeChatListener listener = this.wxListener;
        if (listener != null) {
            listener.onFailure(this, reason);
        }
    }

    private void handleLogin() {
        this.status = 3;
        WeChatListener listener = this.wxListener;
        if (listener != null) {
            listener.onLogin(this);
        }
    }

    private void handleMessage(WXMessage message) {
        this.status = 3;
        WeChatListener listener = this.wxListener;
        if (listener != null) {
            listener.onMessage(this, message);
        }
    }

    private void handleContact(WXContact oldContact, WXContact newContact) {
        this.status = 3;
        WeChatListener listener = this.wxListener;
        if (listener != null) {
            listener.onContact(this, oldContact, newContact);
        }
    }

    private void handleLogout() {
        this.status = 4;
        WeChatListener listener = this.wxListener;
        if (listener != null) {
            listener.onLogout(this);
        }
    }

    private void loadContacts(@Nonnull String userNames, boolean useCache) {
        if (!XTools.strEmpty((String)userNames)) {
            LinkedList<ReqBatchGetContact.Contact> contacts = new LinkedList<ReqBatchGetContact.Contact>();
            for (String userName : userNames.split(",")) {
                if (XTools.strEmpty((String)userName)) continue;
                contacts.add(new ReqBatchGetContact.Contact(userName, ""));
            }
            this.loadContacts(contacts, useCache);
        }
    }

    private void loadContacts(@Nonnull List<ReqBatchGetContact.Contact> contacts, boolean useCache) {
        if (useCache) {
            Iterator<ReqBatchGetContact.Contact> iterator = contacts.iterator();
            while (iterator.hasNext()) {
                ReqBatchGetContact.Contact contact = iterator.next();
                if (contact.UserName.startsWith("@@") || this.wxContacts.getContact(contact.UserName) == null) continue;
                iterator.remove();
            }
        }
        if (contacts.size() > 50) {
            LinkedList<ReqBatchGetContact.Contact> temp = new LinkedList<ReqBatchGetContact.Contact>();
            for (ReqBatchGetContact.Contact contact : contacts) {
                temp.add(contact);
                if (temp.size() < 50) continue;
                RspBatchGetContact rspBatchGetContact = this.wxAPI.webwxbatchgetcontact(contacts);
                for (RspInit.User user : rspBatchGetContact.ContactList) {
                    this.wxContacts.putContact(this.wxAPI.host, user);
                }
                temp.clear();
            }
            contacts = temp;
        }
        if (contacts.size() > 0) {
            RspBatchGetContact rspBatchGetContact = this.wxAPI.webwxbatchgetcontact(contacts);
            for (RspInit.User user : rspBatchGetContact.ContactList) {
                this.wxContacts.putContact(this.wxAPI.host, user);
            }
        }
    }

    public void setListener(@Nonnull WeChatListener listener) {
        this.wxListener = listener;
    }

    @Nullable
    public WeChatListener getListener() {
        return this.wxListener;
    }

    public void startup() {
        this.wxThread.start();
    }

    public int status() {
        return this.status;
    }

    public void shutdown() {
        this.wxAPI.webwxlogout();
        this.wxThread.interrupt();
    }

    public WXUser userMe() {
        return this.wxContacts.getMe();
    }

    @Nullable
    public WXUser userFriend(@Nonnull String userId) {
        return this.wxContacts.getFriend(userId);
    }

    @Nonnull
    public HashMap<String, WXUser> userFriends() {
        return this.wxContacts.getFriends();
    }

    @Nullable
    public WXGroup userGroup(@Nonnull String groupId) {
        return this.wxContacts.getGroup(groupId);
    }

    @Nonnull
    public HashMap<String, WXGroup> userGroups() {
        return this.wxContacts.getGroups();
    }

    @Nullable
    public WXContact userContact(@Nonnull String contactId) {
        return this.wxContacts.getContact(contactId);
    }

    @Nonnull
    public WXText sendText(@Nonnull WXContact wxContact, @Nonnull String text) {
        XTools.logN((String)LOG_TAG, (String)"\u5411\uff08%s\uff09\u53d1\u9001\u6d88\u606f\uff1a%s", (Object[])new Object[]{wxContact.id, text});
        RspSendMsg rspSendMsg = this.wxAPI.webwxsendmsg(new ReqSendMsg.Msg(1, null, 0, text, null, this.wxContacts.getMe().id, wxContact.id));
        WXText wxText = new WXText();
        wxText.id = Long.valueOf(rspSendMsg.MsgID);
        wxText.idLocal = Long.valueOf(rspSendMsg.LocalID);
        wxText.timestamp = System.currentTimeMillis();
        wxText.fromGroup = null;
        wxText.fromUser = this.wxContacts.getMe();
        wxText.toContact = wxContact;
        wxText.content = text;
        return wxText;
    }

    @Nullable
    public WXMessage sendFile(@Nonnull WXContact wxContact, @Nonnull File file) {
        String suffix = WeChatTools.fileSuffix(file);
        if ("mp4".equals(suffix) && file.length() >= 0x1400000L) {
            XTools.logW((String)LOG_TAG, (String)"\u5411\uff08%s\uff09\u53d1\u9001\u7684\u89c6\u9891\u6587\u4ef6\u5927\u4e8e20M\uff0c\u65e0\u6cd5\u53d1\u9001", (Object[])new Object[]{wxContact.id});
            return null;
        }
        try {
            XTools.logN((String)LOG_TAG, (String)"\u5411\uff08%s\uff09\u53d1\u9001\u6587\u4ef6\uff1a%s", (Object[])new Object[]{wxContact.id, file.getAbsolutePath()});
            String mediaId = null;
            String aesKey = null;
            String signature = null;
            if (file.length() >= 0x1900000L) {
                RspCheckUpload rspCheckUpload = this.wxAPI.webwxcheckupload(file, this.wxContacts.getMe().id, wxContact.id);
                mediaId = rspCheckUpload.MediaId;
                aesKey = rspCheckUpload.AESKey;
                signature = rspCheckUpload.Signature;
            }
            if (XTools.strEmpty(mediaId)) {
                RspUploadMedia rspUploadMedia = this.wxAPI.webwxuploadmedia(this.wxContacts.getMe().id, wxContact.id, file, aesKey, signature);
                mediaId = rspUploadMedia.MediaId;
            }
            if (!XTools.strEmpty(mediaId)) {
                switch (WeChatTools.fileType(file)) {
                    case "pic": {
                        RspSendMsg rspSendMsg = this.wxAPI.webwxsendmsgimg(new ReqSendMsg.Msg(3, mediaId, null, "", signature, this.wxContacts.getMe().id, wxContact.id));
                        WXImage wxImage = new WXImage();
                        wxImage.id = Long.valueOf(rspSendMsg.MsgID);
                        wxImage.idLocal = Long.valueOf(rspSendMsg.LocalID);
                        wxImage.timestamp = System.currentTimeMillis();
                        wxImage.fromGroup = null;
                        wxImage.fromUser = this.wxContacts.getMe();
                        wxImage.toContact = wxContact;
                        wxImage.imgWidth = 0;
                        wxImage.imgHeight = 0;
                        wxImage.image = this.wxAPI.webwxgetmsgimg(wxImage.id, "slave");
                        wxImage.origin = file;
                        return wxImage;
                    }
                    case "video": {
                        RspSendMsg rspSendMsg = this.wxAPI.webwxsendvideomsg(new ReqSendMsg.Msg(43, mediaId, null, "", signature, this.wxContacts.getMe().id, wxContact.id));
                        WXVideo wxVideo = new WXVideo();
                        wxVideo.id = Long.valueOf(rspSendMsg.MsgID);
                        wxVideo.idLocal = Long.valueOf(rspSendMsg.LocalID);
                        wxVideo.timestamp = System.currentTimeMillis();
                        wxVideo.fromGroup = null;
                        wxVideo.fromUser = this.wxContacts.getMe();
                        wxVideo.toContact = wxContact;
                        wxVideo.imgWidth = 0;
                        wxVideo.imgHeight = 0;
                        wxVideo.image = this.wxAPI.webwxgetmsgimg(wxVideo.id, "slave");
                        wxVideo.videoLength = 0;
                        wxVideo.video = file;
                        return wxVideo;
                    }
                }
                if ("gif".equals(suffix)) {
                    RspSendMsg rspSendMsg = this.wxAPI.webwxsendemoticon(new ReqSendMsg.Msg(47, mediaId, 2, "", signature, this.wxContacts.getMe().id, wxContact.id));
                    WXImage wxImage = new WXImage();
                    wxImage.id = Long.valueOf(rspSendMsg.MsgID);
                    wxImage.idLocal = Long.valueOf(rspSendMsg.LocalID);
                    wxImage.timestamp = System.currentTimeMillis();
                    wxImage.fromGroup = null;
                    wxImage.fromUser = this.wxContacts.getMe();
                    wxImage.toContact = wxContact;
                    wxImage.imgWidth = 0;
                    wxImage.imgHeight = 0;
                    wxImage.image = file;
                    wxImage.origin = file;
                    return wxImage;
                }
                StringBuilder sbAppMsg = new StringBuilder();
                sbAppMsg.append("<appmsg appid='wxeb7ec651dd0aefa9' sdkver=''>");
                sbAppMsg.append("<title>").append(file.getName()).append("</title>");
                sbAppMsg.append("<des></des>");
                sbAppMsg.append("<action></action>");
                sbAppMsg.append("<type>6</type>");
                sbAppMsg.append("<content></content>");
                sbAppMsg.append("<url></url>");
                sbAppMsg.append("<lowurl></lowurl>");
                sbAppMsg.append("<appattach>");
                sbAppMsg.append("<totallen>").append(file.length()).append("</totallen>");
                sbAppMsg.append("<attachid>").append(mediaId).append("</attachid>");
                sbAppMsg.append("<fileext>").append(XTools.strEmpty((String)suffix) ? "undefined" : suffix).append("</fileext>");
                sbAppMsg.append("</appattach>");
                sbAppMsg.append("<extinfo></extinfo>");
                sbAppMsg.append("</appmsg>");
                RspSendMsg rspSendMsg = this.wxAPI.webwxsendappmsg(new ReqSendMsg.Msg(6, null, null, sbAppMsg.toString(), signature, this.wxContacts.getMe().id, wxContact.id));
                WXFile wxFile = new WXFile();
                wxFile.id = Long.valueOf(rspSendMsg.MsgID);
                wxFile.idLocal = Long.valueOf(rspSendMsg.LocalID);
                wxFile.timestamp = System.currentTimeMillis();
                wxFile.fromGroup = null;
                wxFile.fromUser = this.wxContacts.getMe();
                wxFile.toContact = wxContact;
                wxFile.content = sbAppMsg.toString();
                wxFile.fileSize = file.length();
                wxFile.fileName = file.getName();
                wxFile.fileId = mediaId;
                wxFile.file = file;
                return wxFile;
            }
            XTools.logE((String)LOG_TAG, (String)"\u5411\uff08%s\uff09\u53d1\u9001\u7684\u6587\u4ef6\u53d1\u9001\u5931\u8d25", (Object[])new Object[]{wxContact.id});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nonnull
    public WXLocation sendLocation(@Nonnull WXContact wxContact, @Nonnull String lon, @Nonnull String lat, @Nonnull String title, @Nonnull String lable) {
        XTools.logN((String)LOG_TAG, (String)"\u5411\uff08%s\uff09\u53d1\u9001\u4f4d\u7f6e\u4fe1\u606f\uff0c\u5750\u6807\uff1a%s,%s\uff0c\u8bf4\u660e\uff1a%s(%s)", (Object[])new Object[]{wxContact.id, lon, lat, title, lable});
        StringBuilder sbLocationMsg = new StringBuilder();
        sbLocationMsg.append("<?xml version=\"1.0\"?>\n");
        sbLocationMsg.append("<msg>\n");
        sbLocationMsg.append("<location x=\"" + lat + "\" y=\"" + lon + "\" scale=\"15\" label=\"" + lable + "\" maptype=\"roadmap\" poiname=\"" + title + "\" poiid=\"City\" />\n");
        sbLocationMsg.append("</msg>\n");
        RspSendMsg rspSendMsg = this.wxAPI.webwxsendmsg(new ReqSendMsg.Msg(48, null, 0, sbLocationMsg.toString(), null, this.wxContacts.getMe().id, wxContact.id));
        WXLocation wxLocation = new WXLocation();
        wxLocation.id = Long.valueOf(rspSendMsg.MsgID);
        wxLocation.idLocal = Long.valueOf(rspSendMsg.LocalID);
        wxLocation.timestamp = System.currentTimeMillis();
        wxLocation.fromGroup = null;
        wxLocation.fromUser = this.wxContacts.getMe();
        wxLocation.toContact = wxContact;
        wxLocation.content = sbLocationMsg.toString();
        return wxLocation;
    }

    @Nullable
    public WXContact fetchContact(@Nonnull String contactId) {
        this.loadContacts(contactId, false);
        WXContact contact = this.wxContacts.getContact(contactId);
        if (contact instanceof WXGroup) {
            LinkedList<ReqBatchGetContact.Contact> contacts = new LinkedList<ReqBatchGetContact.Contact>();
            for (WXGroup.Member member : ((WXGroup)contact).members.values()) {
                contacts.add(new ReqBatchGetContact.Contact(member.id, contact.id));
            }
            this.loadContacts(contacts, true);
            ((WXGroup)contact).isDetail = true;
        }
        return contact;
    }

    @Nonnull
    public WXContact fetchAvatar(@Nonnull WXContact wxContact) {
        wxContact.avatarFile = XTools.http((XHttpExecutor)XHttpTools.EXECUTOR, (XHttpExecutor.Request)XRequest.GET((String)wxContact.avatarUrl)).file(this.wxAPI.folder.getAbsolutePath() + File.separator + String.format("avatar-%d.jpg", System.currentTimeMillis() + (long)new Random().nextInt(1000)));
        return wxContact;
    }

    @Nonnull
    public WXImage fetchImage(@Nonnull WXImage wxImage) {
        wxImage.origin = this.wxAPI.webwxgetmsgimg(wxImage.id, "big");
        return wxImage;
    }

    @Nonnull
    public WXVoice fetchVoice(@Nonnull WXVoice wxVoice) {
        wxVoice.voice = this.wxAPI.webwxgetvoice(wxVoice.id);
        return wxVoice;
    }

    @Nonnull
    public WXVideo fetchVideo(@Nonnull WXVideo wxVideo) {
        wxVideo.video = this.wxAPI.webwxgetvideo(wxVideo.id);
        return wxVideo;
    }

    @Nonnull
    public WXFile fetchFile(@Nonnull WXFile wxFile) {
        wxFile.file = this.wxAPI.webwxgetmedia(wxFile.id, wxFile.fileName, wxFile.fileId, wxFile.fromUser.id);
        return wxFile;
    }

    public void revokeMsg(@Nonnull WXMessage wxMessage) {
        XTools.logN((String)LOG_TAG, (String)"\u64a4\u56de\u5411\uff08%s\uff09\u53d1\u9001\u7684\u6d88\u606f\uff1a%s\uff0c%s", (Object[])new Object[]{wxMessage.toContact.id, wxMessage.idLocal, wxMessage.id});
        this.wxAPI.webwxrevokemsg(wxMessage.idLocal, wxMessage.id, wxMessage.toContact.id);
    }

    public void passVerify(@Nonnull WXVerify wxVerify) {
        XTools.logN((String)LOG_TAG, (String)"\u901a\u8fc7\u597d\u53cb\uff08%s\uff09\u7533\u8bf7", (Object[])new Object[]{wxVerify.userId});
        this.wxAPI.webwxverifyuser(3, wxVerify.userId, wxVerify.ticket, "");
    }

    public void editRemark(@Nonnull WXUser wxUser, @Nonnull String remark) {
        XTools.logN((String)LOG_TAG, (String)"\u4fee\u6539\uff08%s\uff09\u7684\u5907\u6ce8\uff1a%s", (Object[])new Object[]{wxUser.id, remark});
        this.wxAPI.webwxoplog(2, 0, wxUser.id, remark);
    }

    public void topContact(@Nonnull WXContact wxContact, boolean isTop) {
        XTools.logN((String)LOG_TAG, (String)"\u8bbe\u7f6e\uff08%s\uff09\u7684\u7f6e\u9876\u72b6\u6001\uff1a%s", (Object[])new Object[]{wxContact.id, isTop});
        this.wxAPI.webwxoplog(3, isTop ? 1 : 0, wxContact.id, null);
    }

    public void setGroupName(@Nonnull WXGroup wxGroup, @Nonnull String name) {
        XTools.logN((String)LOG_TAG, (String)"\u4e3a\u7fa4\uff08%s\uff09\u4fee\u6539\u540d\u79f0\uff1a%s", (Object[])new Object[]{wxGroup.id, name});
        this.wxAPI.webwxupdatechartroom(wxGroup.id, "modtopic", name, new LinkedList<String>());
    }

    private class WeChatThread
    extends Thread {
        private WeChatThread() {
        }

        @Override
        public void run() {
            int loginCount = 0;
            while (!this.isInterrupted()) {
                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u6b63\u5728\u767b\u5f55", (Object[])new Object[0]);
                String loginErr = this.login();
                if (!XTools.strEmpty((String)loginErr)) {
                    XTools.logE((String)WeChatClient.LOG_TAG, (String)"\u767b\u5f55\u51fa\u73b0\u9519\u8bef\uff1a%s", (Object[])new Object[]{loginErr});
                    WeChatClient.this.handleFailure(loginErr);
                    return;
                }
                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u6b63\u5728\u521d\u59cb\u5316", (Object[])new Object[0]);
                String initErr = this.initial();
                if (!XTools.strEmpty((String)initErr)) {
                    XTools.logE((String)WeChatClient.LOG_TAG, (String)"\u521d\u59cb\u5316\u51fa\u73b0\u9519\u8bef\uff1a%s", (Object[])new Object[]{initErr});
                    WeChatClient.this.handleFailure(initErr);
                    return;
                }
                WeChatClient.this.handleLogin();
                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u6b63\u5728\u76d1\u542c\u6d88\u606f", (Object[])new Object[0]);
                String listenErr = this.listen();
                if (!XTools.strEmpty((String)listenErr)) {
                    if (loginCount++ <= 10) continue;
                    WeChatClient.this.handleFailure(listenErr);
                    return;
                }
                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u6b63\u5728\u9000\u51fa\u767b\u5f55", (Object[])new Object[0]);
                WeChatClient.this.handleLogout();
                return;
            }
        }

        @Nullable
        private String login() {
            try {
                if (XTools.strEmpty((String)((WeChatClient)WeChatClient.this).wxAPI.sid)) {
                    String qrCode = WeChatClient.this.wxAPI.jslogin();
                    XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u7b49\u5f85\u626b\u63cf\u4e8c\u7ef4\u7801\uff1a%s", (Object[])new Object[]{qrCode});
                    WeChatClient.this.handleQRCode(qrCode);
                    block7: while (true) {
                        RspLogin rspLogin = WeChatClient.this.wxAPI.login();
                        switch (rspLogin.code) {
                            case 200: {
                                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u5df2\u6388\u6743\u767b\u5f55", (Object[])new Object[0]);
                                WeChatClient.this.wxAPI.webwxnewloginpage(rspLogin.redirectUri);
                                return null;
                            }
                            case 201: {
                                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u5df2\u626b\u63cf\u4e8c\u7ef4\u7801", (Object[])new Object[0]);
                                WeChatClient.this.handleAvatar(rspLogin.userAvatar);
                                continue block7;
                            }
                            case 408: {
                                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u7b49\u5f85\u6388\u6743\u767b\u5f55", (Object[])new Object[0]);
                                continue block7;
                            }
                        }
                        break;
                    }
                    XTools.logW((String)WeChatClient.LOG_TAG, (String)"\u767b\u5f55\u8d85\u65f6", (Object[])new Object[0]);
                    return WeChatClient.LOGIN_TIMEOUT;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                XTools.logW((String)WeChatClient.LOG_TAG, (Throwable)e, (String)"\u767b\u5f55\u5f02\u5e38", (Object[])new Object[0]);
                return WeChatClient.LOGIN_EXCEPTION;
            }
        }

        @Nullable
        private String initial() {
            try {
                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u6b63\u5728\u83b7\u53d6Cookie", (Object[])new Object[0]);
                for (HttpCookie cookie : XHttpTools.EXECUTOR.getCookies()) {
                    if ("wxsid".equalsIgnoreCase(cookie.getName())) {
                        ((WeChatClient)WeChatClient.this).wxAPI.sid = cookie.getValue();
                        continue;
                    }
                    if ("wxuin".equalsIgnoreCase(cookie.getName())) {
                        ((WeChatClient)WeChatClient.this).wxAPI.uin = cookie.getValue();
                        continue;
                    }
                    if (!"webwx_data_ticket".equalsIgnoreCase(cookie.getName())) continue;
                    ((WeChatClient)WeChatClient.this).wxAPI.dataTicket = cookie.getValue();
                }
                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u6b63\u5728\u83b7\u53d6\u81ea\u8eab\u4fe1\u606f", (Object[])new Object[0]);
                RspInit rspInit = WeChatClient.this.wxAPI.webwxinit();
                WeChatClient.this.wxContacts.setMe(((WeChatClient)WeChatClient.this).wxAPI.host, rspInit.User);
                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u6b63\u5728\u83b7\u53d6\u5e76\u4fdd\u5b58\u6700\u8fd1\u8054\u7cfb\u4eba", (Object[])new Object[0]);
                WeChatClient.this.loadContacts(rspInit.ChatSet, true);
                WeChatClient.this.wxAPI.webwxstatusnotify(((WeChatClient)WeChatClient.this).wxContacts.getMe().id, 3);
                XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u6b63\u5728\u83b7\u53d6\u597d\u53cb\u3001\u7fa4\u3001\u516c\u4f17\u53f7\u5217\u8868", (Object[])new Object[0]);
                RspGetContact rspGetContact = WeChatClient.this.wxAPI.webwxgetcontact();
                for (RspInit.User user : rspGetContact.MemberList) {
                    WeChatClient.this.wxContacts.putContact(((WeChatClient)WeChatClient.this).wxAPI.host, user);
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                XTools.logW((String)WeChatClient.LOG_TAG, (String)"\u521d\u59cb\u5316\u5f02\u5e38\uff1a%s", (Object[])new Object[]{e.getMessage()});
                return WeChatClient.INIT_EXCEPTION;
            }
        }

        @Nullable
        private String listen() {
            int retryCount = 0;
            try {
                while (!this.isInterrupted()) {
                    WXContact oldContact;
                    RspSyncCheck rspSyncCheck;
                    try {
                        XTools.logD((String)WeChatClient.LOG_TAG, (String)"\u6b63\u5728\u76d1\u542c\u4fe1\u606f", (Object[])new Object[0]);
                        rspSyncCheck = WeChatClient.this.wxAPI.synccheck();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (retryCount++ < 5) {
                            XTools.logW((String)WeChatClient.LOG_TAG, (Throwable)e, (String)"\u76d1\u542c\u5f02\u5e38\uff0c\u91cd\u8bd5\u7b2c%d\u6b21", (Object[])new Object[]{retryCount});
                            continue;
                        }
                        XTools.logE((String)WeChatClient.LOG_TAG, (Throwable)e, (String)"\u76d1\u542c\u5f02\u5e38\uff0c\u91cd\u8bd5\u6b21\u6570\u8fc7\u591a", (Object[])new Object[0]);
                        return WeChatClient.LISTEN_EXCEPTION;
                    }
                    retryCount = 0;
                    if (rspSyncCheck.retcode > 0) {
                        XTools.logW((String)WeChatClient.LOG_TAG, (String)"\u505c\u6b62\u76d1\u542c\u4fe1\u606f\uff1a%d", (Object[])new Object[]{rspSyncCheck.retcode});
                        return null;
                    }
                    if (rspSyncCheck.selector <= 0) continue;
                    RspSync rspSync = WeChatClient.this.wxAPI.webwxsync();
                    if (rspSync.DelContactList != null) {
                        for (RspInit.User user : rspSync.DelContactList) {
                            oldContact = WeChatClient.this.wxContacts.rmvContact(user.UserName);
                            if (oldContact == null || XTools.strEmpty((String)oldContact.name)) continue;
                            XTools.logN((String)WeChatClient.LOG_TAG, (String)"\u5220\u9664\u8054\u7cfb\u4eba\uff08%s\uff09", (Object[])new Object[]{user.UserName});
                            WeChatClient.this.handleContact(oldContact, null);
                        }
                    }
                    if (rspSync.ModContactList != null) {
                        for (RspInit.User user : rspSync.ModContactList) {
                            WXContact newContact;
                            oldContact = WeChatClient.this.wxContacts.getContact(user.UserName);
                            if (oldContact != null && XTools.strEmpty((String)oldContact.name)) {
                                WeChatClient.this.wxContacts.rmvContact(user.UserName);
                                oldContact = null;
                            }
                            if ((newContact = WeChatClient.this.fetchContact(user.UserName)) != null && XTools.strEmpty((String)newContact.name)) {
                                WeChatClient.this.wxContacts.rmvContact(user.UserName);
                                newContact = null;
                            }
                            if (oldContact == null && newContact == null) continue;
                            XTools.logN((String)WeChatClient.LOG_TAG, (String)"\u53d8\u66f4\u8054\u7cfb\u4eba\uff08%s\uff09", (Object[])new Object[]{user.UserName});
                            WeChatClient.this.handleContact(oldContact, newContact);
                        }
                    }
                    if (rspSync.AddMsgList == null) continue;
                    for (RspSync.AddMsg addMsg : rspSync.AddMsgList) {
                        WXMessage wxMessage = this.parseMessage(addMsg);
                        if (wxMessage instanceof WXNotify) {
                            WXNotify wxNotify = (WXNotify)wxMessage;
                            if (wxNotify.notifyCode == 4) {
                                WeChatClient.this.loadContacts(wxNotify.notifyContact, false);
                            }
                        }
                        WeChatClient.this.handleMessage(wxMessage);
                    }
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                XTools.logW((String)WeChatClient.LOG_TAG, (Throwable)e, (String)"\u76d1\u542c\u6d88\u606f\u5f02\u5e38", (Object[])new Object[0]);
                return WeChatClient.LISTEN_EXCEPTION;
            }
        }

        @Nonnull
        private <T extends WXMessage> T parseCommon(@Nonnull RspSync.AddMsg msg, @Nonnull T message) {
            message.id = msg.MsgId;
            message.idLocal = msg.MsgId;
            message.timestamp = msg.CreateTime * 1000L;
            if (msg.FromUserName.startsWith("@@")) {
                Matcher mGroupMsg;
                message.fromGroup = (WXGroup)WeChatClient.this.wxContacts.getContact(msg.FromUserName);
                if (message.fromGroup == null || !message.fromGroup.isDetail || message.fromGroup.members.isEmpty()) {
                    message.fromGroup = (WXGroup)WeChatClient.this.fetchContact(msg.FromUserName);
                }
                if ((mGroupMsg = REX_GROUPMSG.matcher(msg.Content)).matches()) {
                    message.fromUser = (WXUser)WeChatClient.this.wxContacts.getContact(mGroupMsg.group(1));
                    if (message.fromUser == null) {
                        WeChatClient.this.fetchContact(msg.FromUserName);
                        message.fromUser = (WXUser)WeChatClient.this.wxContacts.getContact(mGroupMsg.group(1));
                    }
                    message.toContact = WeChatClient.this.wxContacts.getContact(msg.ToUserName);
                    if (message.toContact == null) {
                        message.toContact = WeChatClient.this.fetchContact(msg.ToUserName);
                    }
                    message.content = mGroupMsg.group(2);
                } else {
                    message.fromUser = null;
                    message.toContact = WeChatClient.this.wxContacts.getContact(msg.ToUserName);
                    if (message.toContact == null) {
                        message.toContact = WeChatClient.this.fetchContact(msg.ToUserName);
                    }
                    message.content = msg.Content;
                }
            } else {
                message.fromGroup = null;
                message.fromUser = (WXUser)WeChatClient.this.wxContacts.getContact(msg.FromUserName);
                if (message.fromUser == null) {
                    message.fromUser = (WXUser)WeChatClient.this.fetchContact(msg.FromUserName);
                }
                message.toContact = WeChatClient.this.wxContacts.getContact(msg.ToUserName);
                if (message.toContact == null) {
                    message.toContact = WeChatClient.this.fetchContact(msg.ToUserName);
                }
                message.content = msg.Content;
            }
            return message;
        }

        @Nonnull
        private WXMessage parseMessage(@Nonnull RspSync.AddMsg msg) {
            try {
                switch (msg.MsgType) {
                    case 1: {
                        if (msg.SubMsgType == 0) {
                            return this.parseCommon(msg, new WXText());
                        }
                        if (msg.SubMsgType != 48) break;
                        WXLocation wxLocation = this.parseCommon(msg, new WXLocation());
                        wxLocation.locationName = wxLocation.content.substring(0, wxLocation.content.indexOf(58));
                        wxLocation.locationImage = String.format("https://%s%s", ((WeChatClient)WeChatClient.this).wxAPI.host, wxLocation.content.substring(wxLocation.content.indexOf(58) + ":<br/>".length()));
                        wxLocation.locationUrl = msg.Url;
                        return wxLocation;
                    }
                    case 3: {
                        WXImage wxImage = this.parseCommon(msg, new WXImage());
                        wxImage.imgWidth = msg.ImgWidth;
                        wxImage.imgHeight = msg.ImgHeight;
                        wxImage.image = WeChatClient.this.wxAPI.webwxgetmsgimg(msg.MsgId, "slave");
                        return wxImage;
                    }
                    case 34: {
                        WXVoice wxVoice = this.parseCommon(msg, new WXVoice());
                        wxVoice.voiceLength = msg.VoiceLength;
                        return wxVoice;
                    }
                    case 37: {
                        WXVerify wxVerify = this.parseCommon(msg, new WXVerify());
                        wxVerify.userId = msg.RecommendInfo.UserName;
                        wxVerify.userName = msg.RecommendInfo.NickName;
                        wxVerify.signature = msg.RecommendInfo.Signature;
                        wxVerify.province = msg.RecommendInfo.Province;
                        wxVerify.city = msg.RecommendInfo.City;
                        wxVerify.gender = msg.RecommendInfo.Sex;
                        wxVerify.verifyFlag = msg.RecommendInfo.VerifyFlag;
                        wxVerify.ticket = msg.RecommendInfo.Ticket;
                        return wxVerify;
                    }
                    case 42: {
                        WXRecommend wxRecommend = this.parseCommon(msg, new WXRecommend());
                        wxRecommend.userId = msg.RecommendInfo.UserName;
                        wxRecommend.userName = msg.RecommendInfo.NickName;
                        wxRecommend.gender = msg.RecommendInfo.Sex;
                        wxRecommend.signature = msg.RecommendInfo.Signature;
                        wxRecommend.province = msg.RecommendInfo.Province;
                        wxRecommend.city = msg.RecommendInfo.City;
                        wxRecommend.verifyFlag = msg.RecommendInfo.VerifyFlag;
                        return wxRecommend;
                    }
                    case 43: {
                        WXVideo wxVideo = this.parseCommon(msg, new WXVideo());
                        wxVideo.imgWidth = msg.ImgWidth;
                        wxVideo.imgHeight = msg.ImgHeight;
                        wxVideo.videoLength = msg.PlayLength;
                        wxVideo.image = WeChatClient.this.wxAPI.webwxgetmsgimg(msg.MsgId, "slave");
                        return wxVideo;
                    }
                    case 47: {
                        if (XTools.strEmpty((String)msg.Content) || msg.HasProductId > 0) {
                            WXEmoji wxEmoji = this.parseCommon(msg, new WXEmoji());
                            wxEmoji.imgWidth = msg.ImgWidth;
                            wxEmoji.imgHeight = msg.ImgHeight;
                            return wxEmoji;
                        }
                        WXImage wxImage = this.parseCommon(msg, new WXImage());
                        wxImage.imgWidth = msg.ImgWidth;
                        wxImage.imgHeight = msg.ImgHeight;
                        wxImage.origin = wxImage.image = WeChatClient.this.wxAPI.webwxgetmsgimg(msg.MsgId, "big");
                        return wxImage;
                    }
                    case 49: {
                        if (msg.AppMsgType == 2) {
                            WXImage wxImage = this.parseCommon(msg, new WXImage());
                            wxImage.imgWidth = msg.ImgWidth;
                            wxImage.imgHeight = msg.ImgHeight;
                            wxImage.origin = wxImage.image = WeChatClient.this.wxAPI.webwxgetmsgimg(msg.MsgId, "big");
                            return wxImage;
                        }
                        if (msg.AppMsgType == 5) {
                            WXLink wxLink = this.parseCommon(msg, new WXLink());
                            wxLink.linkName = msg.FileName;
                            wxLink.linkUrl = msg.Url;
                            return wxLink;
                        }
                        if (msg.AppMsgType == 6) {
                            WXFile wxFile = this.parseCommon(msg, new WXFile());
                            wxFile.fileId = msg.MediaId;
                            wxFile.fileName = msg.FileName;
                            wxFile.fileSize = XTools.strEmpty((String)msg.FileSize) ? 0L : Long.valueOf(msg.FileSize);
                            return wxFile;
                        }
                        if (msg.AppMsgType == 8) {
                            WXImage wxImage = this.parseCommon(msg, new WXImage());
                            wxImage.imgWidth = msg.ImgWidth;
                            wxImage.imgHeight = msg.ImgHeight;
                            wxImage.origin = wxImage.image = WeChatClient.this.wxAPI.webwxgetmsgimg(msg.MsgId, "big");
                            return wxImage;
                        }
                        if (msg.AppMsgType != 2000) break;
                        return this.parseCommon(msg, new WXMoney());
                    }
                    case 51: {
                        WXNotify wxNotify = this.parseCommon(msg, new WXNotify());
                        wxNotify.notifyCode = msg.StatusNotifyCode;
                        wxNotify.notifyContact = msg.StatusNotifyUserName;
                        return wxNotify;
                    }
                    case 10000: {
                        return this.parseCommon(msg, new WXSystem());
                    }
                    case 10002: {
                        Matcher replaceMatcher;
                        WXRevoke wxRevoke = this.parseCommon(msg, new WXRevoke());
                        Matcher idMatcher = REX_REVOKE_ID.matcher(wxRevoke.content);
                        if (idMatcher.find()) {
                            wxRevoke.msgId = Long.valueOf(idMatcher.group(1));
                        }
                        if ((replaceMatcher = REX_REVOKE_REPLACE.matcher(wxRevoke.content)).find()) {
                            wxRevoke.msgReplace = replaceMatcher.group(1);
                        }
                        return wxRevoke;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                XTools.logW((String)WeChatClient.LOG_TAG, (String)"\u6d88\u606f\u89e3\u6790\u5931\u8d25", (Object[])new Object[0]);
            }
            return this.parseCommon(msg, new WXUnknown());
        }
    }

    public static abstract class WeChatListener {
        public abstract void onQRCode(@Nonnull WeChatClient var1, @Nonnull String var2);

        public void onAvatar(@Nonnull WeChatClient client, @Nonnull String base64Avatar) {
        }

        public void onFailure(@Nonnull WeChatClient client, @Nonnull String reason) {
        }

        public void onLogin(@Nonnull WeChatClient client) {
        }

        public void onMessage(@Nonnull WeChatClient client, @Nonnull WXMessage message) {
        }

        public void onContact(@Nonnull WeChatClient client, @Nullable WXContact oldContact, @Nullable WXContact newContact) {
        }

        public void onLogout(@Nonnull WeChatClient client) {
        }
    }
}

