/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.chatapi.wechat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.Scanner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.xuxiaoxiao.chatapi.wechat.WeChatClient;
import me.xuxiaoxiao.chatapi.wechat.entity.contact.WXContact;
import me.xuxiaoxiao.chatapi.wechat.entity.contact.WXGroup;
import me.xuxiaoxiao.chatapi.wechat.entity.contact.WXUser;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXLocation;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXMessage;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXText;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXUnknown;
import me.xuxiaoxiao.chatapi.wechat.entity.message.WXVerify;

public class WeChatDemo {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final WeChatClient.WeChatListener LISTENER = new WeChatClient.WeChatListener(){

        @Override
        public void onQRCode(@Nonnull WeChatClient client, @Nonnull String qrCode) {
            System.out.println("onQRCode\uff1a" + qrCode);
        }

        @Override
        public void onLogin(@Nonnull WeChatClient client) {
            System.out.println(String.format("onLogin\uff1a\u60a8\u6709%d\u540d\u597d\u53cb\u3001\u6d3b\u8dc3\u5fae\u4fe1\u7fa4%d\u4e2a", client.userFriends().size(), client.userGroups().size()));
        }

        @Override
        public void onMessage(@Nonnull WeChatClient client, @Nonnull WXMessage message) {
            System.out.println("\u83b7\u53d6\u5230\u6d88\u606f\uff1a" + GSON.toJson((Object)message));
            if (message instanceof WXVerify) {
                client.passVerify((WXVerify)message);
            } else if (message instanceof WXLocation && message.fromUser != null && !message.fromUser.id.equals(client.userMe().id)) {
                if (message.fromGroup == null) {
                    client.sendLocation(message.fromUser, "120.14556", "30.23856", "\u6211\u5728\u8fd9\u91cc", "\u897f\u6e56");
                }
            } else if (message instanceof WXText && message.fromUser != null && !message.fromUser.id.equals(client.userMe().id) && message.fromGroup == null) {
                client.sendText(message.fromUser, message.content);
            }
        }

        @Override
        public void onContact(@Nonnull WeChatClient client, @Nullable WXContact oldContact, @Nullable WXContact newContact) {
            System.out.println(String.format("\u68c0\u6d4b\u5230\u8054\u7cfb\u4eba\u53d8\u66f4:\u65e7\u8054\u7cfb\u4eba\u540d\u79f0\uff1a%s:\u65b0\u8054\u7cfb\u4eba\u540d\u79f0\uff1a%s", oldContact == null ? "null" : oldContact.name, newContact == null ? "null" : newContact.name));
        }
    };

    public static void main(String[] args) {
        WeChatClient wechatClient = new WeChatClient();
        wechatClient.setListener(LISTENER);
        wechatClient.startup();
        Scanner scanner = new Scanner(System.in);
        while (true) {
            try {
                while (true) {
                    System.out.println("\u8bf7\u8f93\u5165\u6307\u4ee4");
                    switch (scanner.nextLine()) {
                        case "sendText": {
                            System.out.println("toContactId:");
                            String toContactId = scanner.nextLine();
                            System.out.println("textContent:");
                            String text = scanner.nextLine();
                            WXContact contact = wechatClient.userContact(toContactId);
                            if (contact != null) {
                                System.out.println("success:" + GSON.toJson((Object)wechatClient.sendText(contact, text)));
                                break;
                            }
                            System.out.println("\u8054\u7cfb\u4eba\u672a\u627e\u5230");
                            break;
                        }
                        case "sendFile": {
                            System.out.println("toContactId:");
                            String toContactId = scanner.nextLine();
                            System.out.println("filePath:");
                            File file = new File(scanner.nextLine());
                            WXContact contact = wechatClient.userContact(toContactId);
                            if (contact != null) {
                                System.out.println("success:" + GSON.toJson((Object)wechatClient.sendFile(contact, file)));
                                break;
                            }
                            System.out.println("\u8054\u7cfb\u4eba\u672a\u627e\u5230");
                            break;
                        }
                        case "sendLocation": {
                            System.out.println("toContactId:");
                            String toContactId = scanner.nextLine();
                            System.out.println("longitude:");
                            String longitude = scanner.nextLine();
                            System.out.println("latitude:");
                            String latitude = scanner.nextLine();
                            System.out.println("title:");
                            String title = scanner.nextLine();
                            System.out.println("lable:");
                            String lable = scanner.nextLine();
                            WXContact contact = wechatClient.userContact(toContactId);
                            if (contact != null) {
                                System.out.println("success:" + GSON.toJson((Object)wechatClient.sendLocation(contact, longitude, latitude, title, lable)));
                                break;
                            }
                            System.out.println("\u8054\u7cfb\u4eba\u672a\u627e\u5230");
                            break;
                        }
                        case "revokeMsg": {
                            System.out.println("toContactId:");
                            String toContactId = scanner.nextLine();
                            System.out.println("clientMsgId:");
                            String clientMsgId = scanner.nextLine();
                            System.out.println("serverMsgId:");
                            String serverMsgId = scanner.nextLine();
                            WXUnknown wxUnknown = new WXUnknown();
                            wxUnknown.id = Long.valueOf(serverMsgId);
                            wxUnknown.idLocal = Long.valueOf(clientMsgId);
                            wxUnknown.toContact = wechatClient.userContact(toContactId);
                            wechatClient.revokeMsg(wxUnknown);
                            break;
                        }
                        case "passVerify": {
                            System.out.println("userId:");
                            String userId = scanner.nextLine();
                            System.out.println("verifyTicket:");
                            String verifyTicket = scanner.nextLine();
                            WXVerify wxVerify = new WXVerify();
                            wxVerify.userId = userId;
                            wxVerify.ticket = verifyTicket;
                            wechatClient.passVerify(wxVerify);
                            break;
                        }
                        case "editRemark": {
                            System.out.println("userId:");
                            String userId = scanner.nextLine();
                            System.out.println("remarkName:");
                            String remark = scanner.nextLine();
                            WXContact contact = wechatClient.userContact(userId);
                            if (contact instanceof WXUser) {
                                wechatClient.editRemark((WXUser)contact, remark);
                                break;
                            }
                            System.out.println("\u597d\u53cb\u672a\u627e\u5230");
                            break;
                        }
                        case "topContact": {
                            System.out.println("contactId:");
                            String contactId = scanner.nextLine();
                            System.out.println("isTop:");
                            String isTop = scanner.nextLine();
                            WXContact contact = wechatClient.userContact(contactId);
                            if (contact != null) {
                                wechatClient.topContact(contact, Boolean.valueOf(isTop.toLowerCase()));
                                break;
                            }
                            System.out.println("\u8054\u7cfb\u4eba\u672a\u627e\u5230");
                            break;
                        }
                        case "setGroupName": {
                            System.out.println("groupId:");
                            String groupId = scanner.nextLine();
                            System.out.println("name:");
                            String name = scanner.nextLine();
                            WXGroup group = wechatClient.userGroup(groupId);
                            if (group != null) {
                                wechatClient.setGroupName(group, name);
                                break;
                            }
                            System.out.println("\u7fa4\u7ec4\u672a\u627e\u5230");
                            break;
                        }
                        case "quit": {
                            System.out.println("logging out");
                            wechatClient.shutdown();
                            return;
                        }
                        default: {
                            System.out.println("\u672a\u77e5\u6307\u4ee4");
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

